/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;

import java.util.List;

import org.maru.common.KeyGen;
import org.maru.dog.core.Configuration;

public class ActualFieldNameBinderBuilder<T, K> extends AbstractBinderBuilder<T, K> {

    @SuppressWarnings("unchecked")
    public ActualFieldNameBinderBuilder(List<Configuration> configurations, T target, K... inputs) {
        super(configurations,
                new InstanceBinderImpl<T, K>(KeyGen.getKey(target.getClass()), (Class<T>) target.getClass()),
                target, inputs);
    }

    public AbstractTargetDefinitionBuilder<T> getTargetDefinitionBuilder(Class<?> type) {
        return new TargetFieldNameDefinitionBuilder(type);
    }

    public AbstractInputDefinitionBuilder<K> getInputDefinitionBuilder(Class<?> type) {
        return new InputActualFieldNameDefinitionBuilder(type);
    }
}
