/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;

import static org.maru.common.util.ConditionUtil.isNotNull;

import java.lang.reflect.Member;

import org.maru.common.Key;
import org.maru.common.KeyGen;
import org.maru.dog.core.AbstractDefinitionBuilder;
import org.maru.dog.core.Definition;
import org.maru.dog.core.MarkedPoint;

abstract class AbstractTargetDefinitionBuilder<T> extends AbstractDefinitionBuilder<T> {


    AbstractTargetDefinitionBuilder(Class<T> target, Definition<T> definition) {
        super(target, definition);
    }

    @Override
    public void makeMarkedPoint(Member member) {
        MarkedPoint<T> markedPoint = getTargetMarkedPoint(member, target);
        if (isNotNull(markedPoint)) {
            String keyName = markedPoint.getName();
            Key<?> key = KeyGen.getKey(keyName);
            ((BindingDefinition<T>)definition).putMarkedPoint(key, markedPoint);
        }
    }

    /**
     * Gets {@link TargetMarkedPoint}.
     * @param member member
     * @param target target class
     * @return target marked point.
     */
    protected abstract TargetMarkedPoint<T> getTargetMarkedPoint(Member member, Class<T> target);


    protected static <T> TargetMarkedPoint<T> createTargetMarkedPointInstance(Class<T> target,
            String name, Member member, Class<?> inputClass) {
        return new TargetMarkedPoint<T>(target, name, member, inputClass);
    }
}
