/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;

import java.util.Map;

import org.maru.dog.core.Builder;
import org.maru.dog.core.Definition;

abstract class AbstractMapBinderBuilder<T> implements Builder, DefinitionBuilder {

    protected final ClassBuilder<T> targetBuilder;
    protected final Map<String, ?> inputs;
    protected MapBinder<T> mapBinder;

    public AbstractMapBinderBuilder(MapBinder<T> mapBinder, T target, Map<String, ?> inputs) {
        this.targetBuilder = new TargetClassBuilder<T>(target, this);
        this.inputs = inputs;
        this.mapBinder = mapBinder;
    }

    @SuppressWarnings("unchecked")
    public Builder build() {
        targetBuilder.build();
        Definition<T> targetDefinition = targetBuilder.getDefinition();

        BinderProducer binderProducer = new MapBinderProducer<T>(targetDefinition, inputs, (MapBinderImpl<T>) mapBinder);
        binderProducer.validateAndComposeBinder();
        mapBinder = (MapBinder<T>) binderProducer.getBinder();
        return this;
    }

    public MapBinder<T> getMapBinder() {
        return mapBinder;
    }

}
