/*
 * Decompiled with CFR 0.152.
 */
package org.maru.common;

import java.lang.reflect.Type;
import org.maru.common.type.GenericClassType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassAnalyzer<T> {
    protected abstract void createStructureInformation(Class<? super T> var1);

    protected abstract void scan(Class<T> var1);

    protected void recursiveClassScan(Class<? super T> clazz) {
        if (clazz.equals(Object.class)) {
            return;
        }
        Type superClass = clazz.getGenericSuperclass();
        Class<?> classType = GenericClassType.getClassFromType(superClass);
        if (classType != null) {
            this.recursiveClassScan(classType);
        }
        Type[] interfaces = clazz.getGenericInterfaces();
        this.scanInterfaces(interfaces);
        this.createStructureInformation(clazz);
    }

    protected void scanInterfaces(Type[] interfaces) {
        if (interfaces != null && interfaces.length > 0) {
            for (Type type : interfaces) {
                this.scanInterface(type);
            }
        }
    }

    protected void scanInterface(Type type) {
        Class<?> classType = GenericClassType.getClassFromType(type);
        Type[] interfaces = classType.getGenericInterfaces();
        if (interfaces != null && interfaces.length > 0) {
            this.scanInterfaces(interfaces);
        }
        this.createStructureInformation(classType);
    }
}

