/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.core;

import org.maru.common.reflection.Clazz;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassChecker {
    private ClassChecker() {
    }

    public static <T> void checkClassType(Class<T> type) {
        if (Clazz.isAbstractClass(type)) {
            throw new IllegalArgumentException("The " + type.getName() + " is an abstract class.");
        }
        if (Clazz.isInterface(type)) {
            throw new IllegalArgumentException("The " + type.getName() + " is an interface.");
        }
        if (Clazz.isArray(type)) {
            throw new IllegalArgumentException("The " + type.getName() + " is an array type.");
        }
        if (Clazz.isAnnotationClass(type)) {
            throw new IllegalArgumentException("The " + type.getName() + " is an annotaton type.");
        }
    }

    public static <T> void checkInstanceType(T instance) {
        if (Clazz.isClassType(instance)) {
            throw new IllegalArgumentException("The " + instance + " is class type.");
        }
        if (Clazz.isAnnotation(instance)) {
            throw new IllegalArgumentException(" The " + instance + " is an annotation.");
        }
    }
}

