/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.core;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.maru.common.AbstractClassAnalyzer;
import org.maru.common.type.GenericClassType;
import org.maru.common.util.StringUtil;
import org.maru.dog.core.Builder;
import org.maru.dog.core.Definition;
import org.maru.dog.util.RegexpUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDefinitionBuilder<T>
extends AbstractClassAnalyzer<T>
implements Builder {
    private static final String UPPERCSE_ALL_ALPHABET = "[A-Z]";
    protected Class<T> target;
    protected final Definition<T> definition;

    public AbstractDefinitionBuilder(Class<T> target, Definition<T> definition) {
        this.target = target;
        this.definition = definition;
    }

    @Override
    public Builder build() {
        this.scan(this.target);
        return this;
    }

    protected abstract boolean isStoredDefinition();

    protected abstract Definition<T> applyDefinition();

    protected abstract Definition<T> retrieveDefinition();

    public Definition<T> createAndStoreDefinition() {
        if (!this.isStoredDefinition()) {
            this.build();
            this.applyDefinition();
            return this.definition;
        }
        return this.retrieveDefinition();
    }

    public void setTarget(Class<T> target) {
        this.target = target;
    }

    protected void scan(Class<T> clazz) {
        Type superClass = clazz.getGenericSuperclass();
        Class classType = GenericClassType.getClassFromType((Type)superClass);
        if (classType != null) {
            this.recursiveClassScan(classType);
        }
        Type[] interfaces = clazz.getGenericInterfaces();
        this.scanInterfaces(interfaces);
        this.createStructureInformation(clazz);
    }

    protected void createStructureInformation(Class<? super T> target) {
        Method[] methods;
        Field[] fields;
        for (Field f : fields = target.getDeclaredFields()) {
            this.makeMarkedPoint(f);
        }
        for (Method m : methods = target.getDeclaredMethods()) {
            this.makeMarkedPoint(m);
        }
    }

    public abstract void makeMarkedPoint(Member var1);

    protected static String canonicalizeMethodName(String keyName) {
        if (keyName.startsWith("get") || keyName.startsWith("set")) {
            keyName = keyName.substring(3, keyName.length());
        } else if (keyName.startsWith("is")) {
            keyName = keyName.substring(2, keyName.length());
        }
        if (StringUtil.isEmpty((String)keyName)) {
            return keyName;
        }
        char[] ch = keyName.toCharArray();
        String fc = Character.toString(ch[0]);
        if (RegexpUtil.matches(fc, UPPERCSE_ALL_ALPHABET) && ch.length > 1 && !RegexpUtil.matches(Character.toString(ch[1]), UPPERCSE_ALL_ALPHABET)) {
            fc = fc.toLowerCase();
            ch[0] = fc.charAt(0);
            keyName = new String(ch);
        }
        return keyName;
    }
}

