/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.bind;

import java.util.Map;
import org.maru.common.Key;
import org.maru.common.util.ConditionUtil;
import org.maru.dog.bind.BinderFactory;
import org.maru.dog.bind.BinderProducer;
import org.maru.dog.bind.BindingContext;
import org.maru.dog.bind.BindingDefinition;
import org.maru.dog.bind.MapBinderImpl;
import org.maru.dog.bind.MapBindingContextImpl;
import org.maru.dog.bind.MapBindingFactoryImpl;
import org.maru.dog.bind.MemberBinder;
import org.maru.dog.bind.TargetMarkedPoint;
import org.maru.dog.core.Binder;
import org.maru.dog.core.Definition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MapBinderProducer<T>
implements BinderProducer {
    private final Definition<T> targetDefinition;
    private final Map<String, ?> inputs;
    private final MapBinderImpl<T> mapBinder;

    MapBinderProducer(Definition<T> targetDefinition, Map<String, ?> inputs, MapBinderImpl<T> mapBinder) {
        this.targetDefinition = targetDefinition;
        this.inputs = inputs;
        this.mapBinder = mapBinder;
    }

    public Binder getBinder() {
        return this.mapBinder;
    }

    @Override
    public void validateAndComposeBinder() {
        for (Map.Entry entry : ((BindingDefinition)this.targetDefinition).getMarkedPoints().entrySet()) {
            Key<?> targetBoundKey = entry.getKey();
            TargetMarkedPoint targetMarkedPoint = (TargetMarkedPoint)entry.getValue();
            BindingContext context = MapBinderProducer.createMapBindingContext(targetMarkedPoint, targetBoundKey, this.inputs);
            if (!ConditionUtil.isNotNull((Object)context)) continue;
            MemberBinder memberBinder = BinderFactory.createMemberBinder(context, new MapBindingFactoryImpl());
            this.mapBinder.addMemberBinder(memberBinder);
        }
    }

    private static <T> BindingContext createMapBindingContext(TargetMarkedPoint<T> targetMarkedPoint, Key<?> targetBoundKey, Map<String, ?> inputs) {
        MapBindingContextImpl context = null;
        for (Map.Entry<String, ?> entry : inputs.entrySet()) {
            if (!targetMarkedPoint.getName().equals(entry.getKey())) continue;
            context = new MapBindingContextImpl(targetMarkedPoint, entry.getValue());
            break;
        }
        return context;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MapBinderProducer [targetDefinition=" + this.targetDefinition + ",");
        sb.append("inputs=" + this.inputs + ",");
        sb.append("mapBinder=" + this.mapBinder + "]");
        return sb.toString();
    }
}

