/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.bind;

import java.util.List;
import java.util.Map;
import org.maru.common.Key;
import org.maru.common.KeyGen;
import org.maru.common.util.ConditionUtil;
import org.maru.dog.bind.BinderFactory;
import org.maru.dog.bind.BinderProducer;
import org.maru.dog.bind.BindingConfiguration;
import org.maru.dog.bind.BindingContextImpl;
import org.maru.dog.bind.BindingDefinition;
import org.maru.dog.bind.BindingFactoryImpl;
import org.maru.dog.bind.InputMarkedPoint;
import org.maru.dog.bind.InstanceBinderImpl;
import org.maru.dog.bind.MemberBinder;
import org.maru.dog.bind.TargetMarkedPoint;
import org.maru.dog.bind.TypeSafeChecker;
import org.maru.dog.core.Binder;
import org.maru.dog.core.Configuration;
import org.maru.dog.core.Definition;
import org.maru.dog.core.MarkedPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InstanceBinderProducer<T, K>
implements BinderProducer {
    private final Definition<T> targetDefinition;
    private final Map<Key<?>, Definition<K>> inputDefinitions;
    private final InstanceBinderImpl<T, K> instanceBinder;
    private final List<Configuration> configurations;

    InstanceBinderProducer(Definition<T> targetDefinition, Map<Key<?>, Definition<K>> inputDefinitions, List<Configuration> configurations, InstanceBinderImpl<T, K> instanceBinder) {
        this.targetDefinition = targetDefinition;
        this.inputDefinitions = inputDefinitions;
        this.instanceBinder = instanceBinder;
        this.configurations = configurations;
    }

    public Binder getBinder() {
        return this.instanceBinder;
    }

    @Override
    public void validateAndComposeBinder() {
        Key targetTypeKey = KeyGen.getKey(this.targetDefinition.getType());
        for (Map.Entry entry : ((BindingDefinition)this.targetDefinition).getMarkedPoints().entrySet()) {
            Key targetBoundKey = entry.getKey();
            TargetMarkedPoint targetMarkedPoint = (TargetMarkedPoint)entry.getValue();
            Class<?> inputClass = null;
            BindingConfiguration bindingConfiguration = this.searchBindingConfiguration(targetTypeKey, targetBoundKey);
            if (ConditionUtil.isNotNull((Object)bindingConfiguration)) {
                inputClass = bindingConfiguration.getInputClass();
                Key bindKey = ConditionUtil.isNotNull((Object)bindingConfiguration.getBindName()) ? KeyGen.getKey((Object)bindingConfiguration.getBindName()) : targetBoundKey;
                BindingContextImpl context = InstanceBinderProducer.createBindingContext(targetMarkedPoint, bindKey, this.inputDefinitions, inputClass, bindingConfiguration);
                if (!ConditionUtil.isNotNull((Object)context)) continue;
                MemberBinder memberBinder = BinderFactory.createMemberBinder(context, new BindingFactoryImpl());
                this.instanceBinder.addMemberBinder(memberBinder);
                continue;
            }
            inputClass = targetMarkedPoint.getInputClass();
            BindingContextImpl context = InstanceBinderProducer.createBindingContext(targetMarkedPoint, targetBoundKey, this.inputDefinitions, inputClass, null);
            if (!ConditionUtil.isNotNull((Object)context)) continue;
            MemberBinder memberBinder = BinderFactory.createMemberBinder(context, new BindingFactoryImpl());
            this.instanceBinder.addMemberBinder(memberBinder);
        }
    }

    private BindingConfiguration searchBindingConfiguration(Key<?> targetTypeKey, Key<?> targetBoundKey) {
        BindingConfiguration configuration = null;
        if (ConditionUtil.isNotNull(this.configurations) && this.configurations.size() > 0) {
            for (Configuration c : this.configurations) {
                Key configKey = KeyGen.getKey((Object)((BindingConfiguration)c).getBoundName());
                if (!targetBoundKey.equals((Object)configKey)) continue;
                configuration = (BindingConfiguration)c;
                break;
            }
        }
        return configuration;
    }

    private static <T, K> BindingContextImpl createBindingContext(TargetMarkedPoint<T> targetMarkedPoint, Key<?> targetBoundKey, Map<Key<?>, Definition<K>> inputDefinitions, Class<?> inputClass, BindingConfiguration configuration) {
        BindingContextImpl bindingContext = null;
        if (ConditionUtil.isNotNull(inputClass)) {
            Definition<K> inputDefinition;
            Key inputClassKey = KeyGen.getKey(inputClass);
            if (inputDefinitions.containsKey(inputClassKey) && ((BindingDefinition)(inputDefinition = inputDefinitions.get(inputClassKey))).containsMarkedPoint(targetBoundKey)) {
                InputMarkedPoint inputMarkedPoint = (InputMarkedPoint)((BindingDefinition)inputDefinition).getMarkedPoint(targetBoundKey);
                TypeSafeChecker.verifyTypeSafe(inputMarkedPoint, targetMarkedPoint);
                bindingContext = new BindingContextImpl(targetMarkedPoint, inputMarkedPoint, configuration);
            }
        } else {
            int duplicateCount = 0;
            MarkedPoint inputMarkedPoint = null;
            for (Map.Entry<Key<?>, Definition<K>> inputEntry : inputDefinitions.entrySet()) {
                for (Map.Entry definedEntry : ((BindingDefinition)inputEntry.getValue()).getMarkedPoints().entrySet()) {
                    InputMarkedPoint tmpInputMarkedPoint = (InputMarkedPoint)definedEntry.getValue();
                    if (!tmpInputMarkedPoint.getName().equals(targetMarkedPoint.getName())) continue;
                    if (duplicateCount == 0) {
                        inputMarkedPoint = tmpInputMarkedPoint;
                    }
                    ++duplicateCount;
                }
            }
            if (duplicateCount > 1) {
                throw new IllegalArgumentException("The name [" + inputMarkedPoint.getName() + "] is duplicate.");
            }
            if (duplicateCount == 1) {
                TypeSafeChecker.verifyTypeSafe(inputMarkedPoint, targetMarkedPoint);
                bindingContext = new BindingContextImpl(targetMarkedPoint, (InputMarkedPoint<?>)inputMarkedPoint, configuration);
            }
        }
        return bindingContext;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InstanceBinderProducer [targetDefinition=" + this.targetDefinition + ",");
        sb.append("inputDefinitions=" + this.inputDefinitions + ",");
        sb.append("instanceBinder=" + this.instanceBinder + ",");
        sb.append("configurations=" + this.configurations + "]");
        return sb.toString();
    }
}

