/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.bind;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.maru.common.Key;
import org.maru.common.KeyGen;
import org.maru.common.type.PrimitiveWrapperTypes;
import org.maru.dog.bind.ClassBuilder;
import org.maru.dog.bind.DefinitionBuilder;
import org.maru.dog.bind.InputClassBuilder;
import org.maru.dog.bind.InstanceBinder;
import org.maru.dog.bind.InstanceBinderImpl;
import org.maru.dog.bind.InstanceBinderProducer;
import org.maru.dog.bind.TargetClassBuilder;
import org.maru.dog.core.Builder;
import org.maru.dog.core.Configuration;
import org.maru.dog.core.Definition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractBinderBuilder<T, K>
implements Builder,
DefinitionBuilder {
    protected InstanceBinder<T, K> instanceBinder;
    protected final List<Configuration> configurations;
    protected final ClassBuilder<T> targetBuilder;
    protected final List<ClassBuilder<K>> inputBuilders;

    public AbstractBinderBuilder(List<Configuration> configurations, InstanceBinder<T, K> instanceBinder, T target, K ... inputs) {
        this.targetBuilder = new TargetClassBuilder<T>(target, this);
        this.inputBuilders = this.createInputClasBuilder(inputs);
        this.configurations = configurations;
        this.instanceBinder = instanceBinder;
    }

    private List<ClassBuilder<K>> createInputClasBuilder(K ... inputs) {
        ArrayList<ClassBuilder<K>> inputBuilders = new ArrayList<ClassBuilder<K>>();
        for (K input : inputs) {
            Class<?> inputClass = input.getClass();
            if (PrimitiveWrapperTypes.isPrimitiveOrWrapperType(inputClass)) continue;
            inputBuilders.add(new InputClassBuilder<K>(input, this));
        }
        return inputBuilders;
    }

    public InstanceBinder<T, K> getInstanceBinder() {
        return this.instanceBinder;
    }

    @Override
    public Builder build() {
        Map<Key<?>, Definition<K>> inputDefinitions = this.getInputDefinitions();
        this.targetBuilder.build();
        Definition<T> targetDefinition = this.targetBuilder.getDefinition();
        InstanceBinderProducer<T, K> binderProducer = new InstanceBinderProducer<T, K>(targetDefinition, inputDefinitions, this.configurations, (InstanceBinderImpl)this.instanceBinder);
        binderProducer.validateAndComposeBinder();
        this.instanceBinder = (InstanceBinder)((Object)binderProducer.getBinder());
        return this;
    }

    private Map<Key<?>, Definition<K>> getInputDefinitions() {
        HashMap definitions = new HashMap();
        for (ClassBuilder<K> builder : this.inputBuilders) {
            builder.build();
            Key key = KeyGen.getKey(builder.getType());
            Definition<K> definition = builder.getDefinition();
            definitions.put(key, definition);
        }
        return definitions;
    }
}

