/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.m4hv.extensions.validator;

import java.util.Locale;
import java.util.ResourceBundle;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import org.maru.m4hv.extensions.constraints.NotHaveInValidCharacter;

public class NotHaveInValidCharacterValidator extends AbstractValidityCharacter implements ConstraintValidator<NotHaveInValidCharacter, String> {

    public void initialize(NotHaveInValidCharacter notHaveInValidCharacter) {
        bundle = ResourceBundle.getBundle(notHaveInValidCharacter.resource(), Locale.getDefault());
        createKeySets(notHaveInValidCharacter.keys());
    }

    public boolean isValid(String object, ConstraintValidatorContext constraintContext) {
        if (object == null) {
            return true;
        }
        return validateCharacter(object);
    }

    @Override
    protected boolean checkCharacter(String letter) {
        for (String key : keySets) {
            String value = bundle.getString(key);
            String[] comparingCharacters = getComparingCharacters(value);
            for (String comparingCharacter : comparingCharacters) {
                if (letter.equals(comparingCharacter)) {
                    return true;
                }
            }
        }

        return false;
    }

}
