package org.maru.m4hv.extensions.validator;

import java.text.BreakIterator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;

abstract class AbstractValidityCharacter {

    private static final String COMMA_SEPARATOR  = ",";

    protected ResourceBundle bundle;

    protected Set<String> keySets;

    protected void createKeySets(String[] keys) {
        keySets = new HashSet<String>();
        if (keys.length > 0) {
            for (String key : keys) {
                if (key != null && !key.equals("")) {
                    keySets.add(key);
                }
            }
        } else {
            Enumeration<String> allKeys = bundle.getKeys();
            while (allKeys.hasMoreElements()) {
                String key = allKeys.nextElement();
                keySets.add(key);
            }
        }
    }

    protected boolean validateCharacter(String object) {
        BreakIterator breakIterator = BreakIterator.getCharacterInstance();
        breakIterator.setText(object);

        for (int start = breakIterator.first(), end = breakIterator.next();
                end != BreakIterator.DONE;
                start = end, end = breakIterator.next()) {
            StringBuilder sb = new StringBuilder();
            for (int i = start; i < end; i++) {
                sb.append(object.charAt(i));
            }
            String letter = sb.toString();

            boolean isInValid = checkCharacter(letter);
            if (isInValid == true) {
                return false;
            }
        }
        return true;
    }

    protected abstract boolean checkCharacter(String letter);

    protected static String[] getComparingCharacters(String value) {
        if (!value.equals(COMMA_SEPARATOR)) {
            return value.split(COMMA_SEPARATOR);
        } else {
            return new String[]{value};
        }
    }
}
