/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.m4hv.extensions.constraints;

import static java.lang.annotation.ElementType.CONSTRUCTOR;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

import org.maru.m4hv.extensions.validator.KatakanaValidator;

/**
 * Katakana validator.<br>
 * This validator validates the value passed as a parameter is Katakana.
 * Validating the katakana punctuation and the iteration mark and the katakana digraph is optional.
 * If you would like to validate those, turn on the those flags to true and you might
 * sometimes include space in your validating value, for this requirement {@code Katakana}
 * annotation has enableSpace flag to validate the value including space. We have option
 * to validate the types of spaces whick is fullwidth space or hulfwidth space or both.
 *
 * Katakana phonetic extensions character option is supported from version 1.4.1
 *
 */
@Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER})
@Retention(RUNTIME)
@Constraint(validatedBy = KatakanaValidator.class)
@Documented
public @interface Katakana {

    String message() default "{org.maru.m4hv.extensions.Katakana.message}";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

    boolean enablePunctuation() default false;

    boolean enableIterationMarks() default false;

    boolean enableKatakanaDigraph() default false;

    boolean enablePhoneticExtensions() default false;

    boolean enableSpace() default false;

    SpaceType spaceType() default SpaceType.BOTH;

    @Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER})
    @Retention(RUNTIME)
    @Documented
    @interface List {
        Katakana[] value();
    }
}
