/*
 * Decompiled with CFR 0.152.
 */
package org.maru.m4hv.extensions.validator;

import java.text.BreakIterator;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.maru.m4hv.extensions.constraints.CharLength;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharLengthValidator
implements ConstraintValidator<CharLength, String> {
    private int min;
    private int max;

    public void initialize(CharLength charLength) {
        this.min = charLength.min();
        this.max = charLength.max();
    }

    public boolean isValid(String object, ConstraintValidatorContext constraintContext) {
        if (object == null) {
            return true;
        }
        BreakIterator breakIterator = BreakIterator.getCharacterInstance();
        breakIterator.setText(object);
        int charCount = 0;
        int start = breakIterator.first();
        int end = breakIterator.next();
        while (end != -1) {
            ++charCount;
            start = end;
            end = breakIterator.next();
        }
        return charCount >= this.min && charCount <= this.max;
    }
}

