/*
 * Decompiled with CFR 0.152.
 */
package org.maru.m4hv.extensions.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.maru.m4hv.extensions.constraints.AlphabetNumber;
import org.maru.m4hv.extensions.constraints.CasePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphabetNumberValidator
implements ConstraintValidator<AlphabetNumber, String> {
    private static final String BOTH_ALPHABET_NUMBER_PATTERN = "[a-zA-Z0-9]*";
    private static final String UPPER_ALPHABET_NUMBER_PATTERN = "[A-Z0-9]*";
    private static final String LOWER_ALPHABET_NUMBER_PATTERN = "[a-z0-9]*";
    private CasePattern casePattern;

    public void initialize(AlphabetNumber alphabetNumber) {
        this.casePattern = alphabetNumber.value();
    }

    public boolean isValid(String object, ConstraintValidatorContext constraintContext) {
        if (object == null) {
            return true;
        }
        Pattern pattern = AlphabetNumberValidator.createPattern(this.casePattern);
        Matcher matcher = pattern.matcher(object);
        return matcher.matches();
    }

    private static Pattern createPattern(CasePattern casePattern) {
        switch (casePattern) {
            case BOTH: {
                return Pattern.compile(BOTH_ALPHABET_NUMBER_PATTERN);
            }
            case UPPER: {
                return Pattern.compile(UPPER_ALPHABET_NUMBER_PATTERN);
            }
            case LOWER: {
                return Pattern.compile(LOWER_ALPHABET_NUMBER_PATTERN);
            }
        }
        throw new IllegalArgumentException("Unexpected pattern :" + (Object)((Object)casePattern));
    }
}

