/*
 * Decompiled with CFR 0.152.
 */
package org.maru.m4hv.extensions.validator;

import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.maru.m4hv.extensions.constraints.ActualDate;
import org.maru.m4hv.extensions.util.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActualDateValidator
implements ConstraintValidator<ActualDate, String> {
    private Date startDate;
    private Date endDate;
    private String[] patterns;
    private static final String EXCEPTION_MESSAGE = "Unexpected date : ";

    public void initialize(ActualDate actualDate) {
        this.patterns = actualDate.patterns();
        String start = actualDate.from();
        this.startDate = DateUtil.canonicalize(start, this.patterns, EXCEPTION_MESSAGE);
        String end = actualDate.until();
        this.endDate = end != null && !end.equals("") ? DateUtil.canonicalize(end, this.patterns, EXCEPTION_MESSAGE) : null;
    }

    public boolean isValid(String date, ConstraintValidatorContext constraintContext) {
        Date inputDate;
        if (date == null) {
            return true;
        }
        try {
            inputDate = DateUtil.canonicalize(date, this.patterns, EXCEPTION_MESSAGE);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (this.endDate != null) {
            return inputDate.compareTo(this.startDate) >= 0 && inputDate.compareTo(this.endDate) <= 0;
        }
        return inputDate.compareTo(this.startDate) >= 0;
    }
}

