/*
MapEditorOne
Marathon and AlephOne's Map file editor
Copyright (C) 2007  Koji Koizumi(HN:HogePiyo)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#pragma once

#include <wx/wxprec.h>
#include <wx/bitmap.h>
#include <wx/dcbuffer.h>
#include <wx/bmpbuttn.h>
#include <wx/sizer.h>
#include <wx/cursor.h>
#include <wx/xrc/xmlres.h>
#include <wx/filedlg.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
// Include your minimal set of headers here, or wx.h
#include <wx/wx.h>
#endif
#include "wx/settings.h"


#include <HPLLib/HPLAlephLib.h>
#include <MapEditorOneSetting.h>
#include <MapEditorOneInnerSetting.h>


#include <vector>
#include <string>

static wxString TITLE_TEXT_BASE = wxString(_T("Map Editor One"));

class MapEditorMainFrame;

//Î̎
enum{
    _no_selected,
    _selected_point,
    _selected_line,
    _selected_polygon,
    _selected_object,
};

/**
    AvP[ṼCNX
*/
class MapEditorWX: public wxApp
{
public:

    //////////////////////////////////////////////
    ////// Level names
    //level names stock
    std::vector<std::string> levelNameList;

    //editing level index
    int editLevelIndex;

    //color for polygon type
    int polygonTypeColors[NUMBER_OF_POLYGON_TYPE][3];
    
    //color for height(variables)
    //TODO height pr
    int heightColorList[2][3];

    ///////////////////////
    //IuWFNg֘A
    //IuWFNg^Cv
    hpl::aleph::Information objectTypeInfo[NUMBER_OF_MAP_OBJECT_TYPES];
        //X^[
        hpl::aleph::Information monsterTypeInfo[NUMBER_OF_MONSTER_TYPES];
        //IuWF
        hpl::aleph::Information sceneryTypeInfo[NUMBER_OF_SCENERY_DEFINITIONS];
        //ACe
        hpl::aleph::Information itemTypeInfo[NUMBER_OF_DEFINED_ITEMS];
        //
        hpl::aleph::Information soundSourceTypeInfo[NUMBER_OF_AMBIENT_SOUND_DEFINITIONS];
        //N
        hpl::aleph::Information activateTypeInfo[NUMBER_OF_ACTIVATE_TYPES];

    //tO
    hpl::aleph::InformationBinded flagInfo[NUMBER_OF_OBJECT_FLAGS];

    ////////////////////////
    //}bv֘A
    //
    hpl::aleph::Information envInfo[NUMBER_OF_ENVIRONMENTS];
    //wi
    hpl::aleph::Information landscapeInfo[NUMBER_OF_LANDSPACES];
    //TODO Q[^Cv
    //NUMBER_OF_GAME_TYPES
    //^Cv
    hpl::aleph::InformationBinded envTypeInfo[NUMBER_OF_ENV_TYPES];
    //~bV^Cv
    hpl::aleph::InformationBinded missionTypeInfo[NUMBER_OF_MISSION_TYPES];

    //^[~i^Cv
    hpl::aleph::Information terminalTypeInfo[NUMBER_OF_GROUP_TYPES];

    //|S^Cv
    hpl::aleph::Information polygonTypeInfo[NUMBER_OF_POLYGON_TYPE];

    //͉y
    hpl::aleph::Information ambientSoundTypeInfo[NUMBER_OF_AMBIENT_SOUND_DEFINITIONS];
    //_TEh
    hpl::aleph::Information randomSoundTypeInfo[NUMBER_OF_RANDOM_SOUND_DEFINITIONS];

    ////////////////////////
    //I
    //IΏۂID
    hpl::aleph::map::HPLSelectData selectData;

    //Rsyŕێf[^
    hpl::aleph::map::HPLRealMapData storedMapData;
    //炷ʒu
    int storedDataDiffPointDelta[2];

/*    //ACeACR
    wxBitmap itemIconBitmaps[NUMBER_OF_DEFINED_ITEMS];
    wxBitmap hilightedItemIconBitmaps[NUMBER_OF_DEFINED_ITEMS];

    //}bvACR
    wxBitmap mapIconBitmaps[NUMBER_OF_MAP_ICONS];
    wxBitmap hilightedMapIconBitmaps[NUMBER_OF_MAP_ICONS];
*/

    ///////////////////////
    // ǉ
    //ǉɂŏ̓_w肩H
    bool isFirstOfLineToAdd;
    //OI_̃CfbNX
    int prevPointIndex;
    
    //ҏWݒ
    MapEditorOneSetting setting;

    //Shapes[hH
    bool isLoadedShapesFile;

    //vZbgŒǉ|S̒_
    int nPolygonPoints;

    //eNX`f[^
    //TODO texture
    std::vector<std::vector<wxBitmap> > textureBitmaps;

    //ҏW[hƃj[ID̑Ή
    //TODO menu
    std::map<int, int> menuIDMap;

    //\[Xt@C
    wxXmlResource xrc;

    //͈͊O̐\邩ǂ(ftHg:false)
    bool isRevealHiddenLines;

    //}bvύXꂽ
    bool isChanged;
    //t@CpX
    wxString filePath;

    //vZbgŒǉ|S̒_
    int presetPolygonVertexCount;

    //݂̃|Cg͓_̏ɂ邩H
    //A͈͂̊OɂꍇlȂ
    bool isNowOnThePoint;
    bool isNowOnTheLine;

    wxMenu linePopupMenu;
    wxMenu pointPopupMenu;

    //popuppCfbNXo
    int popupEndpointIndex;
    int popupLineIndex;
    //public oϐ ܂
private:
    
    ///////////////////////
    // view grid
    /** r[Obh}l[W[ */
    hpl::aleph::view::HPLViewGridManager viewGridManager;

    //CxgǗ
    hpl::aleph::HPLEventManager eventManager;

    //XgbNǗ
    hpl::aleph::HPLStockManager stockManager;


    //c[Ƃ̃J[\
    wxCursor cursors[ToolType::NUMBER_OF_TOOLS];

    //ICJ[\
    wxCursor onLineCursor;
    //I|CgJ[\
    wxCursor onPointCursor;
    //ʏ탉CJ[\
    //wxCursor lineToolCursor;

    //ǉJ[\
    wxCursor onLineCursorAdding;
    wxCursor onPointCursorAdding;
    wxCursor lineToolCursorAdding;

    //EChEt[
    MapEditorMainFrame *frame;
public:
    ///////////////////////////////////
    ///////////////////////////////////
    // ֐

    /**
        r[Obh̒}l[W[擾܂
    */
    hpl::aleph::view::HPLViewGridManager* getViewGridManager();

    virtual bool OnInit();
    /**
        ʓIȏ
    */
    bool initialize();


    //Cxg}l[W[擾܂
    hpl::aleph::HPLEventManager* getEventManager();

    //XgbN}l[W擾܂
    hpl::aleph::HPLStockManager* getStockManager();

    //r[W[hWɒ̊ȈՔ
    world_point2d getWorldPointFromViewPoint(int vx, int vy);
    //
    void getViewPointFromWorldPoint(world_point2d& wpoint, int vpoint[2]);
    void getViewPointFromWorldPoint(int x, int y, int vpoint[2])
    {
        world_point2d wpoint = {x,y};
        this->getViewPointFromWorldPoint(wpoint, vpoint);
    }

    /**
        rbg}bv̓ǂݍ݁iȈՔŁj
    */
    void loadBitmap(const char* fname, wxImage* bitmap);

    /**
        ݂̃[hEc[ɂ킹ăJ[\ύX܂
    */
    void setCursor();

    /**
        ҏW܂
    */
    void resetLineEditInfo();
private:

};

//̂܂
DECLARE_APP(MapEditorWX)

//char->wx
wxString getString(const char* format, ...);
