#include "MapEditorWX.h"
#include "MapEditorMainFrame.h"

IMPLEMENT_APP(MapEditorWX)

//load color informations

const int WINDOW_DEFAULT_WIDTH = 800;
const int WINDOW_DEFAULT_HEIGHT = 600;
const int WINDOW_DEFAULT_X = 50;
const int WINDOW_DEFAULT_Y = 50;
const int BUF_MAX = 1024;


bool MapEditorWX::OnInit()
{
    //ʓIȏݒ
    if(!this->initialize()){
        wxMessageBox(_T("Initialize failure"));
        exit(-1);
    }

    //EChEt[𐶐܂
    frame = new MapEditorMainFrame(
        TITLE_TEXT_BASE,
        wxPoint(WINDOW_DEFAULT_X, WINDOW_DEFAULT_Y), wxSize(WINDOW_DEFAULT_WIDTH, WINDOW_DEFAULT_HEIGHT));
    frame->Show(true);
    //SetTopWindow(frame);

    
    return TRUE;
}

bool MapEditorWX::initialize()
{
    //ݒǂݍ
    setting.setIniFileName(INI_FILE_NAME);
    if(!setting.loadSetting()){
        hpl::error::caution("No setting file found. I'll make default one.");
        setting.setSettingToDefault();
        //ۑ
        setting.saveSetting();
    }
    //levelNameList

    //
    this->editLevelIndex = 0;

    //polygonTypeColorList
    //heightColorList

    //ǂݍ

    //IuWFNgS
    hpl::aleph::loadInformation("data/ObjectTypes.txt", NUMBER_OF_OBJECT_TYPES, this->objectTypeInfo);
    //X^[
    hpl::aleph::loadInformation("data/MonsterTypes.txt", NUMBER_OF_MONSTER_TYPES, this->monsterTypeInfo);
    //IuWF
    hpl::aleph::loadInformation("data/SceneryTypes.txt", NUMBER_OF_SCENERY_DEFINITIONS, this->sceneryTypeInfo);
    //ACe
    hpl::aleph::loadInformation("data/DefinedItems.txt", NUMBER_OF_DEFINED_ITEMS, this->itemTypeInfo);
    //
    hpl::aleph::loadInformation("data/SoundSourceTypes.txt", NUMBER_OF_AMBIENT_SOUND_DEFINITIONS, this->soundSourceTypeInfo);
    //N
    hpl::aleph::loadInformation("data/ActivateTypes.txt", NUMBER_OF_ACTIVATE_TYPES, this->activateTypeInfo);

    //tO
    this->flagInfo[0].bind = _map_object_is_invisible;
    this->flagInfo[1].bind = _map_object_hanging_from_ceiling;
    this->flagInfo[2].bind = _map_object_is_blind;
    this->flagInfo[3].bind = _map_object_is_deaf;
    this->flagInfo[4].bind = _map_object_floats;
    this->flagInfo[5].bind = _map_object_is_network_only;

    //^[~i
    hpl::aleph::loadInformation("data/TerminalGroupTypes.txt", NUMBER_OF_GROUP_TYPES, this->terminalTypeInfo);

    //|S
    hpl::aleph::loadInformation("data/PolygonType.txt", NUMBER_OF_POLYGON_TYPE, this->polygonTypeInfo);

    //
    hpl::aleph::loadInformation("data/Environments.txt", NUMBER_OF_ENVIRONMENTS, this->envInfo);
    //wi
    hpl::aleph::loadInformation("data/Landscapes.txt", NUMBER_OF_LANDSPACES, this->landscapeInfo);

    //env type(bind)
    this->envTypeInfo[0].bind = _environment_normal;
    this->envTypeInfo[1].bind = _environment_vacuum;
    this->envTypeInfo[2].bind = _environment_magnetic;
    this->envTypeInfo[3].bind = _environment_rebellion;
    this->envTypeInfo[4].bind = _environment_low_gravity;
    this->envTypeInfo[5].bind = _environment_network;
    this->envTypeInfo[6].bind = _environment_single_player;
    //mission type(bind)
    this->missionTypeInfo[0].bind = _mission_none;
    this->missionTypeInfo[1].bind = _mission_extermination;
    this->missionTypeInfo[2].bind = _mission_exploration;
    this->missionTypeInfo[3].bind = _mission_retrieval;
    this->missionTypeInfo[4].bind = _mission_repair;
    this->missionTypeInfo[5].bind = _mission_rescue;

    //wi
    hpl::aleph::loadInformation("data/AmbientSoundTypes.txt", NUMBER_OF_AMBIENT_SOUND_DEFINITIONS, this->ambientSoundTypeInfo);
    //wi
    hpl::aleph::loadInformation("data/RandomSoundTypes.txt", NUMBER_OF_RANDOM_SOUND_DEFINITIONS, this->randomSoundTypeInfo);

    //Fݒǂݍ
    if(!hpl::aleph::loadColorSetting(POLYGON_COLOR_FILE_NAME, this->polygonTypeColors, NUMBER_OF_POLYGON_TYPE)){
        return false;
    }

    //I֘A
    this->selectData.clear();

    //RsypXgbN
    storedDataDiffPointDelta[0] = storedDataDiffPointDelta[1] = 0;

    //̍ŏ̓_
    isFirstOfLineToAdd = true;
    //ȑOI_
    prevPointIndex = NONE;

    //Obhݒ
    mapeditorone::MapEditorOneInnerSetting innerSetting =
        mapeditorone::MapEditorOneInnerSetting(TAG_NAME_FILE_PATH, INNER_DATA_FILE_PATH);
    mapeditorone::setupGridManager(this->getViewGridManager(),
        &innerSetting);
    this->getViewGridManager()->setGridIntervalIndex(this->setting.getGridSizeIndex());
    nPolygonPoints = 3;

    //TODO textureBitmaps

    //J[\ǂݍ <en> load cursor images
    /*
        TI_ARROW = 0,
        TI_FILL,
        TI_HAND,
        TI_LINE,
        TI_MAGNIFY,
        TI_SKULL,
        TI_TEXT,
        TI_POLYGON,
    */
    char CURSOR_BASE_DIR[] = "data/img/";
    char *cursorSkull = "cursor2.bmp";
    char *cursorPolygon = "cur00004.bmp";
    char *cursorLine = "LineCursor1.bmp";

    int cursorId[] ={
        wxCURSOR_ARROW,
        wxCURSOR_PAINT_BRUSH,
        wxCURSOR_HAND,
        -1,
        wxCURSOR_MAGNIFIER,
        -1,
        wxCURSOR_IBEAM,
        -1
    };
    //J[\f[^ǂݍ
    for(int i = 0; i < ToolType::NUMBER_OF_TOOLS; i ++){
        if(cursorId[i] != -1){
            //K̂̂Ŏg
            cursors[i] = wxCursor(cursorId[i]);
        }else{
            //t@CpX
            char* fname;
            if(i == ToolType::TI_SKULL){
                fname = cursorSkull;
            }else if(i == ToolType::TI_POLYGON){
                fname = cursorPolygon;
            }else if(i == ToolType::TI_LINE){
                fname = cursorLine;
            }
            wxString path = wxConvCurrent->cMB2WX(CURSOR_BASE_DIR);
            wxString pathF = wxConvCurrent->cMB2WX(fname);
            path.Append(pathF);
            //ǂݍ
            wxImage bmp;
            bmp.LoadFile(path);
            bmp.SetMaskColour(255,255,255);
            //J[\ݒ
            cursors[i] = wxCursor(bmp);
        }
    }
    {
        wxImage img;
        wxString str = wxConvCurrent->cMB2WX("data/img/onLine.bmp");
        img.LoadFile(str);
        img.SetMaskColour(255,255,255);
        this->onLineCursor = wxCursor(img);
        img = wxImage();
        img.LoadFile(wxString(wxConvCurrent->cMB2WX("data/img/onPoint.bmp")));
        img.SetMaskColour(255,255,255);
        this->onPointCursor = wxCursor(img);
        //ǉ
        img = wxImage();
        img.LoadFile(wxString(wxConvCurrent->cMB2WX("data/img/onPoint2.bmp")));
        img.SetMaskColour(255,255,255);
        this->onPointCursorAdding = wxCursor(img);
        img = wxImage();
        img.LoadFile(wxString(wxConvCurrent->cMB2WX("data/img/onLine2.bmp")));
        img.SetMaskColour(255,255,255);
        this->onLineCursorAdding = wxCursor(img);
        img = wxImage();
        img.LoadFile(wxString(wxConvCurrent->cMB2WX("data/img/LineCursor2.bmp")));
        img.SetMaskColour(255,255,255);
        this->lineToolCursorAdding = wxCursor(img);
    }

    //ΏۊO̐\邩ǂ
    this->isRevealHiddenLines = false;
    
    this->isNowOnTheLine = this->isNowOnThePoint = false;

    return true;
}


hpl::aleph::view::HPLViewGridManager* MapEditorWX::getViewGridManager()
{
    return &this->viewGridManager;
}
//Cxg}l[W[擾܂
hpl::aleph::HPLEventManager* MapEditorWX::getEventManager()
{
    return &this->eventManager;
}
//XgbN}l[W擾܂
hpl::aleph::HPLStockManager* MapEditorWX::getStockManager()
{
    return &this->stockManager;
}

//r[W[hWɒ̊ȈՔ
world_point2d MapEditorWX::getWorldPointFromViewPoint(int vx, int vy)
{
    hpl::aleph::view::HPLViewGridManager* mgr = this->getViewGridManager();
    int offset[2];
    mgr->getOffset(offset);
    int DIV = mgr->getZoomDivision();
    world_point2d wpoint = hpl::aleph::map::getWorldPoint2DFromViewPoint(vx, vy,
        OFFSET_X_WORLD, OFFSET_Y_WORLD, DIV, offset[0], offset[1]);
    return wpoint;
}
//
void MapEditorWX::getViewPointFromWorldPoint(world_point2d& wpoint, int vpoint[2])
{
    hpl::aleph::view::HPLViewGridManager* mgr = this->getViewGridManager();
    int offset[2];
    mgr->getOffset(offset);
    int DIV = mgr->getZoomDivision();
    hpl::aleph::map::getViewPointFromWorldPoint2D(wpoint, vpoint,
        OFFSET_X_WORLD, OFFSET_Y_WORLD, DIV, offset[0], offset[1]);
}


/**
    rbg}bv̓ǂݍ݁iȈՔŁj
*/
void MapEditorWX::loadBitmap(const char* fname, wxImage* bitmap)
{
    if(!bitmap->LoadFile(wxConvCurrent->cMB2WX(fname), wxBITMAP_TYPE_BMP)){
        hpl::error::halt("Couldn't load bitmap[%s]", fname);
    }
}

/**
    ݂̃[hEc[ɂ킹ăJ[\ύX܂
*/
void MapEditorWX::setCursor()
{
    int editMode = this->getEventManager()->getEditModeType();
    int toolType = this->getEventManager()->getToolType();
    if(editMode == EditModeType::EM_DRAW){
        if(toolType == ToolType::TI_LINE){
            if(this->isNowOnTheLine){
                if(this->isFirstOfLineToAdd){
                    //̏ɂ
                    wxSetCursor(this->onLineCursor);
                }else{
                    wxSetCursor(this->onLineCursorAdding);
                }
            }else if(toolType == ToolType::TI_LINE && this->isNowOnThePoint){
                if(this->isFirstOfLineToAdd){
                    //_̏ɂ
                    wxSetCursor(this->onPointCursor);
                }else{
                    wxSetCursor(this->onPointCursorAdding);
                }
            }else{
                if(this->isFirstOfLineToAdd){
                    wxSetCursor(cursors[toolType]);
                }else{
                    wxSetCursor(this->lineToolCursorAdding);
                }
            }
        }else{
            //TODO J[\
            ::wxSetCursor(cursors[toolType]);
        }
    }else{
        //ɂ
        ::wxSetCursor(cursors[0]);
    }
}
/**
    ҏW܂
*/
void MapEditorWX::resetLineEditInfo()
{
    prevPointIndex = NONE;
    isFirstOfLineToAdd = true;
}

//char->wx
wxString getString(const char* format, ...)
{
    char message[BUF_MAX];
    va_list maker;
    va_start(maker, format);
    vsprintf(message, format, maker);
    wxString str = wxConvertMB2WX(message);
    return str;
}
