#ifndef _HPL_MAP_TOOL_
#define _HPL_MAP_TOOL_

#include <math.h>
#include <vector>
#include <map>
#include <string>
#include <set>

#include "map.h"
#include "wad.h"

//#include "HPLMath.h"
#include "HPLSelectData.h"
//#include "HPLStockManager.h"


#ifdef __WXDEBUG__
#include <wx/defs.h>
#include <wx/debug.h>
#endif

namespace hpl{namespace aleph{
class HPLStockManager;
}};

/*
const int NUMBER_OF_POLYGON_TYPE = 24;
const int NUMBER_OF_ZOOM_DIVISION = 3;
const int NUMBER_OF_OBJECT_TYPES = 6;
const int NUMBER_OF_ACTIVATE_TYPES = 4;
const int NUMBER_OF_MAP_OBJECT_TYPES = 6;
*/


//ނłȂ
namespace hpl{
namespace aleph{
    //
    typedef struct Information_tag{
        std::string jname;
    }Information;

    //l
    typedef struct InformationBinded_tag{
        std::string jname;
        int bind;
    }InformationBinded;

    /**
        ^Of[^擾܂
        load data strings from file
        @param filePath t@CpX file path
        @param maxLines ős
        @param infos o
    */
    void loadInformation(const char* filePath, int maxLines, hpl::aleph::Information infos[]);

    /**
        J[f[^t@Cǂݍ݂܂
        @return sɋU
    */
    bool loadColorSetting(const char* filePath, int colors[][3], int max);

    /**
		vectoȓindexԖڂ̗vf폜܂
		ӁIindex+1Ԗڈȍ~SĂI
	*/
	template<class T>
	void removeIndexInVector(std::vector<T>* items, int index)
	{
		if(index < 0 || index >= (int)items->size()){
			return;
		}
		std::vector<T>::iterator it = items->begin();
		it += index;
		items->erase(it);
	}
};
};

namespace hpl{
namespace aleph{
namespace map{

	///////////////////////////////////////////////////////////////////////
	///////////	 Points	 //////////////////////////////////////////////////
	/**
		<jp>w肵_NbNǂ̔s܂
		<en>is view-point near world-point?
		@param viewPX	point(mouse/view)		    r[WiXN[Wj
		@param worldPX	point(world)			    ΏۂƂ_iWj
		@param offsetViewX offset of view		    r[W̃Y
		@param offsetWorldX offset of world		    W̃Y
		@param distance check distance threshold    臒l
	*/
	bool isSelectPoint(int viewPX, int viewPY, 
					   int worldPX, int worldPY,
					   int offsetViewX, int offsetViewY,
					   int offsetWorldX, int offsetWorldY,
					   int div,
					   int distance);
    /**
        <jp>w肵_(point1)}EX̍W(point0)NbNǂ𔻒肵܂
        <en>check which two world-points are near or not
        @param point0 world-point0  _
        @param point1 world-point1  _
        @param distance threshold   臒l
    */
	bool isSelectPoint(world_point2d &point0, world_point2d &point1,
					   int distance);
	
	/**
		<jp>w肵_Obhɍ킹A̍W𓾂܂
		<en>snap point to grid
		@param srcPoint                         ̍W
		@param destPoint snapped point			Obhɍ킳ꂽ_W
		@param gridInterval interval of grids	ObhԊu
	*/
	void getSnapedPointToGrid(world_point2d &srcPoint, world_point2d* destPoint,
		int gridInterval);

	/**
		<jp>w肵_Aѓ_Lƃ|Sǂ?
	*/
//	  bool isValidPoint(int index);

	//convert view <-> world point
	world_point2d getWorldPoint2DFromViewPoint(int viewPX, int viewPY,
	    int offsetXWorld, int offsetYWorld, int zoomDivision, int offsetx, int offsety);
	void getViewPointFromWorldPoint2D(world_point2d& point, int *dest,
	    int offsetXWorld, int offsetYWorld, int zoomDivision, int offsetx, int offsety);

    /**
        w肵ꏊɓ_邩ǂ𓾂܂
        @param wpoint [hW̓_
        @param threshold _Ƃ̋ȉȂ΋߂ƌȂBViewWn̋w肷
        @param zMin, zMax `FbNp
        @return ̏ꏊɓ_΂̃CfbNX܂B
            ȂNONE
    */
    int getSelectPointIndex(world_point2d& wpoint, int threshold,
        int zMin, int zMax, int div,
                                        hpl::aleph::HPLStockManager* smgr);
    int getSelectPointIndex(int viewX, int viewY, int threshold, int zMin, int zMax,
        int voffsetX, int voffsetY, int offsetXW, int offsetYW, int div,
                                        hpl::aleph::HPLStockManager* smgr);

    /**
        鍂K͈͓ɂ邩m߂܂
        @return 鍂x͈̔͂K͈͂ƋL镔Ȃꍇ
    */
    bool isValidHeight(int checkMin, int checkMax, int validMin, int validMax);

    /**
        w肵_𓥂łꍇA̓_
    */
    int getSelectLineIndex(world_point2d& wpoint, int threshold, int zMin, int zMax, int div,
                                        hpl::aleph::HPLStockManager* smgr);
    int getSelectLineIndex(int viewX, int viewY, int threshold, int zMin, int zMax,
        int voffsetX, int voffsetY, int offsetXW, int offsetYW, int div,
                                        hpl::aleph::HPLStockManager* smgr);

	///////////////////////	 Lines	////////////////////////////////////////////
	/**
		w肵_pƂɐIłĂ邩𔻒
		is view-point near world-line?
		@param viewPX	point(mouse/view)
		@param worldPX0 line's point(world)                     
		@param offsetViewX offset of view                       viewW̃Y
		@param offsetWorldX offset of world                     worldW̃YiSʒuj
		@param distance distance threshold which grab or not    ߂ǂ臒l
        @return true when mouse can grab line                   IłĂtrue
	*/
	bool isSelectLine(int viewPX, int viewPY,
					   int worldPX0, int worldPY0,
					   int worldPX1, int worldPY1,
					   int offsetViewX, int offsetViewY,
					   int offsetWorldX, int offsetWorldY,
					   int div,
					   int distance);

    /**
        <jp>IłĂ邩f
        <en>check which mouse grob line
        @param point mouse location in view
        @param linePoint0
        @param linePoint1 line's location in world
        @param distance distance threshold which grab or not
        @return true when mouse can grab line
    */
	bool isSelectLine(world_point2d &point,
					  world_point2d &linePoint0, world_point2d &linePoint1,
					  int distance, int div);

	/**
		̒擾
        get line's length (calc length, not get from its structure::length)
		@param index f[^̃CfbNX
        @return line(index)'s length
	*/
	double getLineLength(int index);

	/*
		̒𓾂
        get line's length from two world points
        
	*/
	double getPointsDistance(world_point2d& pointA, world_point2d& pointB);

	/**
		<jp>XV
		<en>Fix line_data up
        1:calc length
        2:set side
		@param isDeleteOldSide descide which deletes or not gĂȂǏ폜邩
	*/
	void fixLine(int index, bool isDeleteOldSide);

    /**
        \_ɂĎ擾܂
        get line index with two point indexes
        @return ݂ȂꍇNONE
    */
    int getLineIndexFromTwoLPoints(int pindex0, int pindex1);

	/**
		_LCfbNX̃Xg擾܂
	*/
	std::vector<int> getLineIndexesIncludePoint(int endpointIndex);

	/**
		L|S̃Xg擾܂
		line_dataɂ͉E|Sƍ|S̃CfbNXĂ̂łpĂ
		** gΗǂc
	*
	std::vector<int> getPolygonIndexesIncludeLine(int lineIndex);
	*/
	/**
		_L|S̃Xg擾܂
	*/
	std::vector<int> getPolygonIndexesIncludePoint(int endpointIndex);

    /**
        |SɏĂIuWFNg̃CfbNX擾܂
    */
    std::vector<int> getObjectIndexesOnPolygon(int polygonIndex);

	////////////////////////////////////////////////////////////////////////
	///////////	 Sides	////////////////////////////////////////////////////

    /**
        <jp>ǏZbgAbv܂
        <en>
    */
	void fixSide(int sideIndex);

	///////////////////////////////////////////////////////////////////////
	///////////	 Groups	 //////////////////////////////////////////////////
	/**
		}EXɑIĂACeNbNĂ邩m߂܂
		<en>is point in select groups?
		@param px point locatin(view)				}EXʒuir[Wj
		@param offsetViewX offset(view)				r[WY
		@param offsetWorldX offset(world)			W
		@param pointDistance distance as nearby		_p臒l
		@param lineDistance distance as nearby		p臒l
		@param selectInfo select group for check	O[vNX
	*/
	bool isPointInSelection(int px, int py,
							int offsetViewX, int offsetViewY,
							int offsetWorldX, int offsetWorldY,
							int pointDistance,
							int lineDistance,
							int objectDistance,
							hpl::aleph::map::HPLSelectData* selectInfo,
							int heightMax, int heightMin, int div);

    ///////////////////////////////////////////////////////////////////////////////
    ////// Polygon ////////////////////////////////////////////////////////////////

    /**
        |S݂ƂĐǂ𔻒肵܂
        @param index index of polygon which is checked Ώۂ̃|SCfbNX
    */
    bool isValidPolygon(int index);

    /**
        W͂ރ|ŜA|SƂĐĂ̂܂
        łɃ|S݂Ăꍇ͖܂
        @param wpoint T_B͂ރ|ST
        @return |S̎f[^BɐƗǂBf[^createPolygonŐׂ
    */
    std::vector<polygon_data> searchValidPolygon(world_point2d wpoint,
                                              hpl::aleph::HPLStockManager* smgr,
                                              int zMin, int zMax);

    /**
        ̐D萬px߂܂
        @param pIndexA1,2 A1-A2̓_CfbNX
        @param pIndexB1,2 B1-B2̓_CfbNX
    */
    double getTwoLinesDegree(int pIndexA1, int pIndexA2, int pIndexB1, int pIndexB2);
    double getTwoLinesRadian(int pIndexA1, int pIndexA2, int pIndexB1, int pIndexB2);

    /**
        EW|Sf[^܂
        TODO 
        @param points EW
        @param ep ꂽ_f[^
        @param ld ꂽf[^
        @param n np`
    */
    polygon_data createPolygon(world_point2d points[], endpoint_data epd[], line_data ld[],
        int n);

//    void addNewPoint(endpoint_data point);


    /**
        |SZbgAbv܂
        ̓Iɂ́A
        E_̏ԁȀԂvɐ܂
        ESidef[^ݒ肵܂
        E
    */
    //void setupPolygon(int index);

    /**
        w肵_|S̒ɑ݂邩ǂm߂܂
        @
    */
    bool isPointInPolygon(int viewPX, int viewPY, int polygonIndex,
        int offsetXWorld, int offsetYWorld, int zoomDivision, int offsetx, int offsety);
    bool isPointInPolygon(world_point2d& wpoint, int polygonIndex);

    ///////////////////////////////////////////////////////////////////////////////
    ////////// add delete modify it /////////////////////////////////////////////////
	/**
		_ǉ܂
		@param ep ǉ_f[^ilnȂ̂ŃRs[܂j
		@return ǉꂽ_̃CfbNXl
	*/
	int addEndpoint(endpoint_data ep);
	int addLine(line_data line);
	int addSide(side_data side, bool isClockwise);
	int addPolygon(polygon_data polygon);
	int addMapSavedObject(map_object object);
	int addAnnotation(map_annotation annotation);

    //TODO
    //int getEndpointIndexFromAddress(endpoint_data* ep);

    /**
        ȗo[W
    */
    void createPoint(world_point2d& wpoint, endpoint_data* ep);
    /**
        @param polyIndex ڂ|S̃CfbNX
    */
    void createObject(world_point2d& wpoint, int polyIndex, map_object* obj,
                                   int flags, int type, int index);

    /**
        ̓_pĐ|S쐬܂
        <en> create new line and polygon with points already exist
    */
    void createLine(int beginPointIndex, int endPointIndex, line_data* line);
    void createPolygon(int pointIndexes[], int n, polygon_data* poly);

	/**
		_폜܂
		@param index 폜Ώۂ̃CfbNX
		@return 폜sɋUBCfbNXȂꍇȂ
	*/
    /*
	bool deleteEndpoint(int index);
	bool deleteLine(int index);
	bool deleteSide(int index);
	bool deletePolygon(int index);
	bool deleteMapSavedObject(int index);
    */
    /**
        }bvACei_EESideE|SEIuWFNgj
        폜܂
        @ƂẮA
        PF̒[_ȂǁAQƌ폜ΏۂƂȂĂꍇA
            EQƂNONEɂ
            Eg폜ΏۂƂ
        QF폜Ώۂ폜Ă
            E폜ԍ̗
            E둤Ă

        @param 
    */
    bool deleteMapItems(std::vector<bool>& delPoints, std::vector<bool>& delLines,
        std::vector<bool>& delSides,
        std::vector<bool>& delPolygons, std::vector<bool>& delObjects);

    /**
        |SC܂
        TODO
    */
    void fixPolygon(int pindex);

    /**
        Ɨ|Sf[^ǉ܂
		|Sf[^|Cgf[^Ȃǂۂɒǉ܂
    */
    void addNewPolygon(polygon_data& pdata, endpoint_data epd[], line_data ld[], int n);
    void addNewPolygon(world_distance points[][2], int n);
    void addNewPolygon(world_point2d points[], int n);

    /**
        If[^ɃItZbgݒ肵܂B
        @param mx, my }EXW
        @param sel If[^
    */
    void setupSelectDataGroupOffsets(int mx, int my, 
        hpl::aleph::map::HPLSelectData* sel, 
        int voffsetX, int voffsetY, int woffsetX, int woffsetY, int div);

	////////////////////////////////////////////////
	////// objects ////////////////////////////////
	/**
		zu̐ݒ
		@param objectType IuWFNg^Cv
			_saved_item
			_saved_monster
		@param index ǂ̃IuWFNg͈̏ʒu邩
		@param num l
		@return ̌ʂ̐Bzu񂪓ȂꍇNONE()
	*/
	int addInitialPlacementNum(int objectType, int index, int num);
	/**
		zu擾
		@param objectType IuWFNg^Cv
			_saved_item
			_saved_monster
		@param index ǂ̃IuWFNg͈̏ʒu邩
		@return zuBzu⃉_}bNXȂ
			擾łȂꍇNULLԂ܂
	*/
	struct object_frequency_definition* getPlacementData(int objectType, int index);

};
};
};
#endif
