#pragma once

//dialogues
//modal
#include "AnnotationDialog.h"
#include "ColorCustomizeDialog.h"
#include "EditorPreferencesDialog.h"
#include "LevelInfoDialog.h"
#include "PlacementDialog.h"
#include "PlatformDialog.h"
#include "PolygonNumDialog.h"
#include "SelectLevelDialog.h"
#include "TerminalDialog.h"
#include "VisualDialog.h"

//modeless
//tool
#include "ToolDialog.h"
//height
#include "HeightDialog.h"
//palettes
#include "HeightPaletteDialog.h"
#include "LightPaletteDialog.h"
#include "MediaPaletteDialog.h"
#include "SoundPaletteDialog.h"
#include "TextureDialog.h"
//properties
#include "ObjectPropDialog.h"
#include "LinePropDialog.h"
#include "PointPropDialog.h"
#include "PolygonPropDialog.h"
#include "PolygonTypeDialog.h"
#include "SidePropDialog.h"


#include "MapEditorWX.h"
#include "HPLLib/HPLAlephLib.h"

/**
    event id
*/
enum
{
    ID_New = wxID_NEW,
    ID_NewLevel = 0,
    ID_Open = wxID_OPEN,
    ID_Save = wxID_SAVE,
    ID_SaveAs = wxID_SAVEAS,
    ID_Print = wxID_PRINT,
    ID_PrintPreview = wxID_PREVIEW,
    ID_PrintSetup = wxID_PRINT_SETUP,
    ID_Quit = wxID_EXIT,
    ID_About = wxID_ABOUT,

    ID_Undo = wxID_UNDO,
    ID_Cut = wxID_CUT,
    ID_Copy = wxID_COPY,
    ID_Paste = wxID_PASTE,
    ID_Preference = wxID_PREFERENCES,

    //show
    ID_ToolDialog = 1,
    ID_ZoomIn,
    ID_ZoomOut,
    ID_ZoomDefault,
    ID_MoveToCenter,
//    ID_ObjectPropDialog,
    ID_HeightDialog,

    //mode
    ID_DrawPolygonMode,
    ID_VisualMode,
    ID_PolygonTypeMode,
    ID_FloorHeightMode,
    ID_CeilingHeightMode,
    ID_FloorLightMode,
    ID_CeilingLightMode,
    ID_MediaMode,
    ID_FloorTextureMode,
    ID_CeilingTextureMode,

    //Special
    ID_JumpLevel,
    ID_LevelInfo,
    ID_ObjectPlacement,
    ID_TerminalViewer,

    //popup menu
    ID_LineProp,
    ID_ClockwiseSideProp,
    ID_CounterclockwiseSideProp,
    ID_PointProp,
};  

//\[XID
enum{
    ID_ANNOTATION_DIALOG,

};

/**
    editor's main frame
*/
class MapEditorMainFrame: public wxFrame
{
public:
    //vpeB <en> properties
    ObjectPropDialog objPropDialog;
    LinePropDialog linePropDialog;
    PointPropDialog pointPropDialog;
    PolygonTypeDialog polyTypeDialog;
    PolygonPropDialog polyPropDialog;
    SidePropDialog sidePropDialog;
private:
    //_uobt@OpBitmap
    wxBitmap doubleBufferingBitmap;
    //wxMemoryDC doubleBufferingDC;
//    wxBufferedPaintDC bufferedPainDC

    /////////////////////
    //_CAO([hX)
    //tool
    ToolDialog toolDialog;
    // <en> height
    HeightDialog heightDialog;
    //pbg <en> palettes
    HeightPaletteDialog heightPaletteDialog;
    LightPaletteDialog lightPaletteDialog;
    MediaPaletteDialog mediaPaletteDialog;
    SoundPaletteDialog soundPaletteDialog;
    TextureDialog textureDialog;

    //TODO TEhEfBAECg
    //TODO ȏ̃pbg_CAO邱

    //TODO [_ASideI_CAO낤
    //TODO JumpLevel, LevelInfo, Placements, TerminalViewer

    //NƁAFݒύXɂύX邱
    //TODO ݒύXR[h
    //Obhא
    wxPen gridPen;
    //Obh
    wxPen gridLargePen;
    //wiy
    wxPen backgroundPen;
    //wiuV
    wxBrush backgroundBrush;
    //^Cvʃ|SF
    wxBrush polyTypeBrushes[NUMBER_OF_POLYGON_TYPE];
    //|SIԊ|uV
    wxBrush polySelNetBrush;
    //C@bhȃ|S
    wxBrush invalidBrush;
    //IF
    wxPen selectedLinePen;
    //ʏ
    wxPen linePen;
    //ʏ_
    wxPen pointPen;
    wxBrush pointBrush;
    //ʏ|S
    wxBrush polyBrush;

    //ACerbg}bv
    wxImage itemBitmaps[NUMBER_OF_DEFINED_ITEMS];
    //nCCg
    wxImage hilightedItemBitmaps[NUMBER_OF_DEFINED_ITEMS];

    //}bvvfrbg}bvij
    wxImage mapItemBitmaps[NUMBER_OF_MAP_ICONS];
    //nCCg
    wxImage hilightedMapItemBitmaps[NUMBER_OF_MAP_ICONS];

    //
//    wxBitmap 
    //X^[y
    wxPen monsterPen;
    wxPen selectedMonsterPen;
    wxBrush monsterBrush;
    wxBrush selectedMonsterBrush;
    //vC[yEuV
    wxPen playerPen;
    wxPen selectedPlayerPen;
    wxBrush playerBrush;
    wxBrush selectedPlayerBrush;
    //yEuV <en> ally
    wxPen allyPen;
    wxPen selectedAllyPen;
    wxBrush allyBrush;
    wxBrush selectedAllyBrush;

    //͈͑I\
    wxPen selectingPen;

public:
    MapEditorMainFrame(const wxString& title,
        const wxPoint& pos = wxDefaultPosition,
        const wxSize& size = wxDefaultSize);
    virtual ~MapEditorMainFrame();

    //j[<en> menu
    //t@Cj[ <en>Files menu
    void OnNew(wxCommandEvent& ev);
    void OnNewLevel(wxCommandEvent& ev);
    void OnOpen(wxCommandEvent& ev);
    void OnSave(wxCommandEvent& ev);
    void OnSaveAs(wxCommandEvent& ev);
    void OnPrint(wxCommandEvent& ev);
    void OnPrintPreview(wxCommandEvent& ev);
    void OnPrintSetup(wxCommandEvent& ev);
    void OnQuit(wxCommandEvent& ev);
    void OnAbout(wxCommandEvent& ev);

    //ҏWj[<en>Edit menus
    void OnUndo(wxCommandEvent& ev);
    void OnCut(wxCommandEvent& ev);
    void OnCopy(wxCommandEvent& ev);
    void OnPaste(wxCommandEvent& ev);
    void OnPreference(wxCommandEvent& ev);

    //\j[<en>show
    void OnToolDialog(wxCommandEvent& ev);
    void OnZoomIn(wxCommandEvent& ev);
    void OnZoomOut(wxCommandEvent& ev);
    void OnZoomDefault(wxCommandEvent& ev);
    void OnMoveToCenter(wxCommandEvent& ev);
//    void OnObjectPropDialog(wxCommandEvent& ev);
    void OnHeightDialog(wxCommandEvent& ev);

    //[h<en>Mode
    void OnDrawPolygonMode(wxCommandEvent& ev);
    void OnVisualMode(wxCommandEvent& ev);
    void OnPolygonTypeMode(wxCommandEvent& ev);
    void OnFloorHeightMode(wxCommandEvent& ev);
    void OnCeilingHeightMode(wxCommandEvent& ev);
    void OnFloorLightMode(wxCommandEvent& ev);
    void OnCeilingLightMode(wxCommandEvent& ev);
    void OnMediaMode(wxCommandEvent& ev);
    void OnFloorTextureMode(wxCommandEvent& ev);
    void OnCeilingTextureMode(wxCommandEvent& ev);

    //ʃj[<en>Special!
    void OnJumpLevel(wxCommandEvent& ev);
    void OnLevelInfo(wxCommandEvent& ev);
    void OnObjectPlacement(wxCommandEvent& ev);
    void OnTerminalViewer(wxCommandEvent& ev);

    void OnPaint(wxPaintEvent& ev);

    void OnLeftDown(wxMouseEvent& ev);
    void OnLeftUp(wxMouseEvent& ev);
    void OnRightDown(wxMouseEvent& ev);
    void OnRightUp(wxMouseEvent& ev);
    void OnMotion(wxMouseEvent& ev);
    void OnMouseWheel(wxMouseEvent& ev);

    //TCYύX<en>change window size event
    void OnSize(wxSizeEvent& ev);
    //_uobt@O̔wi폜~p<en>to disable erasing backgroud for double buffering
    void OnEraseBackground(wxEraseEvent& ev);

    //
    //Cxge[u쐬<en>declare
    DECLARE_EVENT_TABLE()

private:
    /**
        _uobt@O
        NƃEChETCYύXɌĂ
        <en> setup buffer for double buffering
        call this when (1)starting and (2)resizing window
    */
    void createDoubleBuffer();
    /**
        j[̃ZbgAbv
        <en> setup menu items
    */
    void setupMenus();

    /**
        }bvf[^̕\
        <en> draw map items
    */
    /**
        wi`
        <en> draw background, drawable area, and grid
        @param dc foCXReLXg <en> device context
    */
    void drawBackground(wxDC* dc);
    void drawPolygons(wxDC* dc);
    void drawLines(wxDC* dc);
    void drawSides(wxDC* dc);
    void drawPoints(wxDC* dc);
    void drawObjects(wxDC* dc);
    void drawAnnotations(wxDC* dc);

    //////////////////////////////////
    // ̋KFdoLButtonOn[ҏW[h]
    //           doLButtonOn[h[[h̃c[]
    // <en>     :doLButtonOn[name of Edit Mode]
    //          :doLButtonOn[name of tool in Draw Mode]
    /**
        }EXCxg
    */
    void doLButtonOnDrawMode(wxMouseEvent& ev);
        void doLButtonOnArrowTool(wxMouseEvent& ev);
        void doLButtonOnFillTool(wxMouseEvent& ev);
        void doLButtonOnHandTool(wxMouseEvent& ev);
        void doLButtonOnLineTool(wxMouseEvent& ev);
        void doLButtonOnMagnifyTool(wxMouseEvent& ev);
        void doLButtonOnSkullTool(wxMouseEvent& ev);
        void doLButtonOnTextTool(wxMouseEvent& ev);
        void doLButtonOnPolygonTool(wxMouseEvent& ev);
    void doLButtonOnPolygonMode(wxMouseEvent& ev);
    void doLButtonOnFloorHeightMode(wxMouseEvent& ev);
    void doLButtonOnCeilingHeightMode(wxMouseEvent& ev);
    void doLButtonOnFloorLightMode(wxMouseEvent& ev);
    void doLButtonOnCeilingLightMode(wxMouseEvent& ev);
    void doLButtonOnMediaMode(wxMouseEvent& ev);
    void doLButtonOnFloorTextureMode(wxMouseEvent& ev);
    void doLButtonOnCeilingTextureMode(wxMouseEvent& ev);

    /**
        }EX{^Ƃ
    */
    void doLUpOnArrowTool(wxMouseEvent& ev);
    void doLUpOnPolygonTool(wxMouseEvent& ev);

    // ItZbgw肵}EX|CgɂĈړ܂
    void moveMapOffset(int x, int y);

    /////////////////////////////////////
    // ̋KFdoMouseMotionOn[]
    /**
        c[@h[[hD&D
    */
    void doMouseMotionOnDrawMode(wxMouseEvent& ev);
        void doMouseMotionOnArrowTool(wxMouseEvent& ev);
        void doMouseMotionOnFillTool(wxMouseEvent& ev);
        void doMouseMotionOnHandTool(wxMouseEvent& ev);
        void doMouseMotionOnLineTool(wxMouseEvent& ev);
        void doMouseMotionOnMagnifyTool(wxMouseEvent& ev);
        void doMouseMotionOnSkullTool(wxMouseEvent& ev);
        void doMouseMotionOnTextTool(wxMouseEvent& ev);
        void doMouseMotionOnPolygonTool(wxMouseEvent& ev);
    void doMouseMotionOnPolygonMode(wxMouseEvent& ev);
    void doMouseMotionOnFloorHeightMode(wxMouseEvent& ev);
    void doMouseMotionOnCeilingHeightMode(wxMouseEvent& ev);
    void doMouseMotionOnFloorLightMode(wxMouseEvent& ev);
    void doMouseMotionOnCeilingLightMode(wxMouseEvent& ev);
    void doMouseMotionOnMediaMode(wxMouseEvent& ev);
    void doMouseMotionOnFloorTextureMode(wxMouseEvent& ev);
    void doMouseMotionOnCeilingTextureMode(wxMouseEvent& ev);

    /**
        }bv`puVEỹZbgAbv
        @param setting J[ݒf[^ <en> setting data for color
    */
    void setupPenAndBrush(ColorSettings* setting);

    /**
        ACRp̃rbg}bvt@Cǂݍ݂܂
    */
    void loadIconBitmaps(const char* baseDirPath);

    /**
        ҏW[hj[̃`FbNSĂ͂܂
    */
    void uncheckModesOnMenu();

    /**
        ItZbgݒ肵܂
        @param mx,my r[W̊_ʒu
    */
    void setupSelectDataGroupOffsets(int mx, int my);

    /**
        @param ev
        @return Iɐꍇ^
    */
    bool tryToSelectOneItem(wxMouseEvent& ev);

    /**
        V[hɐ؂ւ܂
    */
    void changeEditMode(int mode);
};
