; GIMP Script-Fu Mansiki Libs

(define ( Mansiki-PapaerUnit ) 
	(gimp-message  "PapaerUnit")
)
;紙のサイズ：紙サイズ横、縦、仕上げ横、縦、内枠のサイズ：横、縦　外枠のサイズ：横、縦　断ち切り幅
;--------------------------------------------------A4サイズを返します。単位はmmで
(define ( MSK-getSizeOfA4) 
    (list "210" "297" "182" "257" "150" "220" "176" "250" "4")	;紙横、縦
)
;--------------------------------------------------B4サイズを返します。単位はmmで
(define ( MSK-getSizeOfB4) 
    (list "257" "364" "220" "310" "180" "270" "210" "297" "5")	
)
;--------------------------------------------------B5サイズを返します。単位はmmで
(define ( MSK-getSizeOfB5) 
    (list "182" "257" "160" "220" "135" "180" "149" "210" "3")	
)
;--------------------------------------------------B5サイズを返します。単位はmmで
(define ( MSK-getSizeOfA5) 
    (list "148" "210" "140" "192" "115" "162" "129" "182" "3")	
)
;--------------------------------------------------サイズ一覧を返します
(define ( MSK-getPaperUnit paperSize) 	
	(let* (
			(papaUnit (MSK-getSizeOfA4))
		)
		(if (equal? paperSize "B4")
			(set! papaUnit (MSK-getSizeOfB4))
		)
		(if (equal? paperSize "B5")
			(set! papaUnit (MSK-getSizeOfB5))
		)
		(if (equal? paperSize "B5P")
			(set! papaUnit (MSK-getSizeOfB5))
		)
		(if (equal? paperSize "A5")
			(set! papaUnit (MSK-getSizeOfA5))
		)
		papaUnit
	)
)
;--------------------------------------------------原稿用紙サイズ一覧を返します
(define ( MSK-getMangaPaperUnit paperSize) 	
	(let* (
			(papaUnit (MSK-getSizeOfA4))
		)
		(if (equal? paperSize "B5")
			(set! papaUnit (MSK-getSizeOfA4))
		)
		(if (equal? paperSize "B5P")
			(set! papaUnit (MSK-getSizeOfA4))
		)
		(if (equal? paperSize "A4")
			(set! papaUnit (MSK-getSizeOfB4))
		)
		(if (equal? paperSize "A5")
			(set! papaUnit (MSK-getSizeOfB5))
		)
		papaUnit
	)
)
;--------------------------------------------------原稿用紙サイズ一覧を返します
(define (MSK-getPaperSizeFromeMangaPaperSize paperSize) 	
	(let* (
			(retPapaerSize "B5")
		)
        (gimp-message  (string-append "getPaperSizeFromeMangaPaperSize S/" paperSize))
		(if (equal? paperSize "B5")
			(set! retPapaerSize "A5")
		)
		(if (equal? paperSize "B5P")
			(set! retPapaerSize "A5")
		)
		(if (equal? paperSize "A4")
			(set! retPapaerSize "B5")
		)
		(if (equal? paperSize "A5")
			(set! retPapaerSize "B6")
		)
        (gimp-message  (string-append "getPaperSizeFromeMangaPaperSizeE /" paperSize))
		retPapaerSize
	)
)
;--------------------------------------------------DPIサイズを返します
(define ( MSK-getPixcelSizePaperUnitByDPI paperSize dpi)
	(let* (
			(papaUnit( MSK-getPaperUnit paperSize) );A4デフォ;紙のサイズ：横、縦、内枠のサイズ：横、縦　外枠のサイズ：横、縦　断ち切り幅
			(X ( MSK-comvertMM2PixcelSizeByDPI (MSK-string2number(MSK-getValueByIndex papaUnit 0)) dpi))
			(Y ( MSK-comvertMM2PixcelSizeByDPI (MSK-string2number(MSK-getValueByIndex papaUnit 1)) dpi))
		)
		(if(string? X)
			(set! X (MSK-string2number X))
		)
		(if(string? Y)
			(set! Y (MSK-string2number Y))
		)
		;(MSK-Trace "getPixcelSizePaperUnitByDPI" (string-append "BEGIN /" paperSize "/" (number->string dpi )))
		(list  X Y )
	)
)
;--------------------------------------------------原稿用紙DPIサイズを返します
(define ( MSK-getPixcelSizeMangaPaperUnitByDPI paperSize dpi)
	(let* (
			(papaUnit( MSK-getMangaPaperUnit paperSize) );A4デフォ;紙のサイズ：横、縦、内枠のサイズ：横、縦　外枠のサイズ：横、縦　断ち切り幅
			(X ( MSK-comvertMM2PixcelSizeByDPI (MSK-string2number(MSK-getValueByIndex papaUnit 0)) dpi))
			(Y ( MSK-comvertMM2PixcelSizeByDPI (MSK-string2number(MSK-getValueByIndex papaUnit 1)) dpi))
		)
		(gimp-message (string-append "aaaa" (MSK-getValueByIndex papaUnit 0) "/" (MSK-getValueByIndex papaUnit 1) "/dpi::" (number->string dpi)))
		(if(string? X)
			(set! X (MSK-string2number X))
		)
		(if(string? Y)
			(set! Y (MSK-string2number Y))
		)
		;(MSK-Trace "getPixcelSizePaperUnitByDPI" (string-append "BEGIN /" paperSize "/" (number->string dpi )))
		(list  X Y )
	)
)
;--------------------------------------------------DPIサイズを返します
(define ( MSK-comvertMM2PixcelSizeByDPI mm dpi) 	
	 (* (/ mm 25.4) dpi)
)
;--------------------------------------------------DPIサイズを返します
(define ( MSK-getPaperSizeRatio sizeOne sizeBase) 	
	(let* (
			(papaUnitOne 	( MSK-getMangaPaperUnit sizeOne ) )
			(papaUnitBase 	( MSK-getMangaPaperUnit sizeBase) )
			(xOne 	(MSK-string2number(MSK-getValueByIndex papaUnitOne 0)))
			(xBase 	(MSK-string2number(MSK-getValueByIndex papaUnitBase 0)))
		)
		(/ xOne xBase)
	)
)
;--------------------------------------------------
(script-fu-register "Mansiki-PapaerUnit"
		    "Mansiki-PapaerUnit(Lib)"
		    "Mansiki"
		    "name"
		    "copyright"
		    "2007/05/27"
		    "GPL"
	)

(script-fu-menu-register "Mansiki-PapaerUnit"
		    "<Toolbox>/Xtns/Script-Fu/Mansiki")
