package mandelbrotExplorer;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;

import javax.swing.JApplet;
import javax.swing.JSplitPane;

public class MandelbrotExplorerApplet extends JApplet {

	private static final long serialVersionUID = 1L;
	
	Mandelbrot mandel;
	private JSplitPane jsp;
	private HistoryTree ht;
	private int dividerPos;
	private double aspectRatio;
	
	public MandelbrotExplorerApplet(){
		
	}
	
	@Override
	public void init() {
		double rLeft,iTop,rWidth,iHeight;
		
		rLeft=-2.0;
		try {
			if( this.getParameter("r_left")!=null ){
				rLeft = Double.parseDouble( this.getParameter("r_left") );
			}
		} catch (NumberFormatException e) {}

		iTop=-1.25;
		try {
			if( this.getParameter("i_top")!=null ){
				iTop = Double.parseDouble( this.getParameter("i_top") );
			}
		} catch (NumberFormatException e) {}

		rWidth=2.5;
		try {
			if( this.getParameter("r_width")!=null ){
				rWidth = Double.parseDouble( this.getParameter("r_width") );
			}
		} catch (NumberFormatException e) {}

		iHeight=2.5;
		try {
			if( this.getParameter("i_height")!=null ){
				iHeight = Double.parseDouble( this.getParameter("i_height") );
			}
		} catch (NumberFormatException e) {}

		dividerPos=300;
		try {
			if( this.getParameter("history_Width")!=null ){
				dividerPos = Integer.parseInt( this.getParameter("history_Width") );
			}
		} catch (NumberFormatException e) {	}

		aspectRatio=0.0;
		try {
			if (this.getParameter("aspect_ratio") != null) {
				aspectRatio = Double.parseDouble(this
						.getParameter("aspect_ratio"));
			}
		} catch (NumberFormatException e) {	}
		//-----------------------------------------------------
		jsp = new JSplitPane();
		
		mandel = new Mandelbrot(new Rectangle2D.Double(rLeft, iTop, rWidth, iHeight), aspectRatio);
		mandel.setSize(this.getWidth()-dividerPos , this.getHeight());
		jsp.setRightComponent(mandel);

        ht = new HistoryTree(mandel);
        ht.setPreferredSize(new Dimension(dividerPos,mandel.getPreferredSize().height));
		jsp.setLeftComponent(ht);
		
		jsp.setDividerLocation(dividerPos);
		this.getContentPane().add(jsp);
		
		//--------------------------------
		mandel.addMandelbrotListener(new MandelbrotAdapter(){
			public void regionUpdate(MandelbrotEvent e){
				ht.addRow(mandel.getMandelbrotSet());
			}
		});
		//-----------------------------------------------------
	}

}
