package mandelbrotExplorer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.concurrent.Callable;

public class MandelbrotDrawing implements Callable<ImagePiece>  {
	private MandelbrotSet ms;
	private Rectangle rect;
	private boolean stop = false;
	private boolean done = false;
	private MandelbrotImage mi;
	
	public MandelbrotDrawing(MandelbrotSet ms,Rectangle r,MandelbrotImage mi){
		if( r.isEmpty() ){ return; }
		this.ms = ms;
		this.rect = new Rectangle(r);
		this.mi=mi;
	}
	
	public boolean isDone(){
		return done;
	}
	
	public ImagePiece call() {
		if( rect.width<= 0  || rect.height<= 0 ) {
			return null;
		}
		
		System.out.printf("start %s:offset(%d,%d):size(%d,%d)\n",Thread.currentThread().getName(),rect.x,rect.y,rect.width,rect.height );
		BufferedImage image = new BufferedImage(rect.width ,rect.height, BufferedImage.TYPE_INT_BGR);
		Graphics2D g = image.createGraphics();

		Point p = new Point(0,0);

		for(p.x=0; p.x<image.getWidth() && !stop; ++p.x){
			for( p.y=0; p.y<image.getHeight() && !stop; ++p.y){
				g.setColor( getColor( ms , rect.x + p.x , rect.y + p.y ) );
				g.fillRect(p.x, p.y, 1, 1);
			}
		}
		
		ImagePiece ip =  null;
		if( !stop ) {
			System.out.printf("end   %s:offset(%d,%d):size(%d,%d)\n",Thread.currentThread().getName(),rect.x,rect.y,rect.width,rect.height );
			ip = new ImagePiece(image,rect);
			mi.paintImagePiece(ip);
		}else{
			System.out.printf("stop  %s:offset(%d,%d):size(%d,%d)\n",Thread.currentThread().getName(),rect.x,rect.y,rect.width,rect.height );
		}
		done = true;
		return ip;
	}
	
	public void stopDrawing(){
		stop = true;
	}
	
	public Rectangle getRect(){
		return new Rectangle(rect);
	}
	
	private Color getColor(MandelbrotSet ms,int r,int i){
		Color rc;
		int nc;

		nc = (int)(ms.calcMandel(r , i , 511));
		
		if( nc>=0 ){
			rc = new Color(((nc>>3)%8)*32 , (nc%8)*32,((nc>>6)%8)*32);
		}else{
			rc = new Color(0,0,0);
		}
		return rc;
	}

}
