package mandelbrotExplorer;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class ImagePiece {
	private BufferedImage image;
	private Rectangle rect;

	public ImagePiece(BufferedImage image,Rectangle rect){
		this.image = image;
		this.rect = new Rectangle(rect);
	}

	public BufferedImage getImage(){
		return image;
	}

	public Rectangle getRect(){
		return new Rectangle(rect);
	}
	
	public String toString(){
		return String.format("(X,Y)=(%d,%d):(w,h)=(%d,%d)",rect.x,rect.y,rect.width,rect.height);
	}
}
