// -*- C++ -*- generated by wxGlade 0.3.5.1 on Wed Jun 29 12:57:38 2005

#include "mnID.h"
#include "mnDef.h"
#include "mnController.h"
#include <wx/config.h>

BEGIN_EVENT_TABLE(mnController, wxEvtHandler)
	EVT_TEXT_ENTER(ID_SearchTextCtrl, mnController::handleSearch)
	EVT_TREE_SEL_CHANGED(ID_SearchTree, mnController::handleTreeItemSelect)
	EVT_TREE_SEL_CHANGING(ID_SearchTree, mnController::handleTreeItemSelecting)
	EVT_TREE_BEGIN_LABEL_EDIT(ID_SearchTree, mnController::handleBeginLabelEdit)
	EVT_TREE_END_LABEL_EDIT(ID_SearchTree, mnController::handleEndLabelEdit)
	EVT_MENU(ID_MenuFileNew, mnController::handleNewButton)
	EVT_MENU(ID_MenuFileRemove, mnController::handleRemoveButton)
	EVT_MENU(ID_MenuFileExit, mnController::handleExit)
	EVT_MENU(ID_MenuFileConfig, mnController::handleConfig)
	EVT_MENU(wxID_ABOUT, mnController::handleAbout)
	EVT_CLOSE(mnController::handleClose)
END_EVENT_TABLE()

mnController::mnController(mnFrame* inframe)
{
	wxString* dirName = new wxString();
	wxString gotDirName;
	wxDirDialog* dlg;

	frame = inframe;
	isEditing = FALSE;

	/* create wiki model */
	wxConfig* config = new wxConfig(wxT(CONF_APP_NAME));
	if(config->Read(wxT(CONF_WIKI_DIR), dirName) == FALSE) {
		delete dirName;
		dlg = new wxDirDialog(frame);
		if(dlg->ShowModal() == wxID_OK) {
			gotDirName = dlg->GetPath();
			wiki = new mnModel(gotDirName.mb_str());
			config->Write(wxT(CONF_WIKI_DIR), gotDirName.c_str());
		}
		else {
			frame->Close();
		}
	}
	else {
		wiki = new mnModel(dirName->mb_str());
	}

	delete config;
}

void mnController::handleConfig(wxCommandEvent& event)
{
	wxDirDialog* dlg;
	wxString gotDirName;
	wxString* dirName = new wxString();

	saveData();

	wxConfig* config = new wxConfig(wxT(CONF_APP_NAME));

	if(config->Read(wxT(CONF_WIKI_DIR), dirName)) {
		if(wxMessageBox(*dirName, wxT("Change data directory?"), wxYES_NO|wxICON_QUESTION) == wxNO){
			delete config;
			isEditing = FALSE;
			return;
		}
	}	

	dlg = new wxDirDialog(frame);
	if(dlg->ShowModal() == wxID_OK) {
		gotDirName = dlg->GetPath();
		delete wiki;
		wiki = new mnModel(gotDirName.mb_str());
		config->Write(wxT(CONF_WIKI_DIR), gotDirName.c_str());
	}
	delete config;

	frame->showSearchResult(wiki);
	isEditing = FALSE;
}

void mnController::handleSearch(wxCommandEvent& event)
{
	wxString* str = new wxString(event.GetString());
	WikiList*       wikiList;
	WikiList::Node* node;

	saveData();

	wikiList = wiki->search(str->mb_str());

	node = wikiList->GetFirst();
	if(!node) {
		wxLogMessage(wxT("Not Found! [%s]"), (const char*)str->c_str());
		return;
	}

	wiki->addSearchStr(str);
	frame->showSearchResult(wiki);
	isEditing = FALSE;
}

void mnController::handleNewButton(wxCommandEvent& event)
{
	if(isEditing) return;

	WikiData* wikiData = wiki->newWikiData();
	frame->showNewItem(wikiData);
	saveData();
	isEditing = TRUE;
}

void mnController::handleRemoveButton(wxCommandEvent& event)
{
	wxTreeItemData* item = frame->getSelectedItem();

	if(item){
		((WikiData*)(item))->removeDataFile();
	}
	else {
		wiki->removeSearchStr(frame->getSelectedLabel());
	}
	frame->showSearchResult(wiki);
	isEditing = FALSE;
}

void mnController::handleTreeItemSelect(wxTreeEvent& event)
{
	frame->showSelectedItemText(event);
	isEditing = FALSE;
}


void mnController::handleTreeItemSelecting(wxTreeEvent& event)
{
	saveData();

	if(frame->isNewItem(event.GetOldItem())) {
		frame->showSearchResult(wiki);
		event.Veto();
	}
}

void mnController::handleBeginLabelEdit(wxTreeEvent& event)
{
	if(!frame->isEditableTreeLabel(event.GetItem())) event.Veto();
}

void mnController::handleEndLabelEdit(wxTreeEvent& event)
{
	wxString newSubject   = event.GetLabel();
	wxTreeItemData* item  = frame->getSelectedItem();

	event.Veto();

	saveData();

	if(item == NULL) return ;
	if(newSubject.Len() == 0) {
		frame->showSearchResult(wiki);
		return;
	}

	((WikiData*)(item))->modSubject(&newSubject);
	frame->showSearchResult(wiki);
}

void mnController::handleClose(wxCloseEvent& event)
{
	saveData();
	frame->Destroy();
}

void mnController::handleExit(wxCommandEvent& event)
{
	frame->Close();
}


void mnController::handleAbout(wxCommandEvent& event)
{
	wxMessageBox(wxT("MalonNote Ver0.9"), wxT("Abount MalonNote"), wxOK|wxICON_INFORMATION);
}



void mnController::saveData()
{
	wxTreeItemData* item         = frame->getSelectedItem();
	wxString        plainTextStr = frame->getPlainText();
	if(item == NULL) return ;

	((WikiData*)(item))->modText(&plainTextStr);
	((WikiData*)(item))->save();
	//frame->showSearchResult(wiki);
}
