#!/usr/bin/ruby
$:.unshift('./lib')
require 'config'
require 'webrick'
require 'erb'
require 'controller'
require 'takeoutModel'


include WEBrick
include ERB::Util

class TakeoutController < Controller

	def initialize(server, *options)
		super
		@menu = TabMenu.new("account.menu")
		@takeout_model = nil
	end

	def init_takeout_model(req)
		if req.query["target_date"] == nil then
			today = Date.today
			@t_date = sprintf("%04d%02d%02d", today.year, today.month, today.day)
		else
			@t_date = req.query["target_date"]
		end
		@t_user = req.query["target_user"]
		@b_user = req.query["base_user"]
		@index  = req.query["index"].to_i

		@takeout_model = TakeoutModel.new(@t_date, @t_user, @b_user)
	end

	def entry(req, res)
		init_takeout_model(req)
		set_view(req, res, "view/takeout.rhtml")
	end

	def add(req, res)
		init_takeout_model(req)
		record = TakeoutRecord.new(nil)
		record.init_with_args(req.query["account_name"],
                              req.query["price"])
		@takeout_model.add(record)
		forward_event(req, res, "/takeout", "entry")
	end
	
    def del(req, res)
		init_takeout_model(req)
		@takeout_model.delete(@index)
		forward_event(req, res, "/takeout", "entry")
	end

    def mod(req, res)
		init_takeout_model(req)
		record = TakeoutRecord.new(nil)
		record.init_with_args(req.query["account_name"],
                              req.query["price"])
		@takeout_model.modify(record, @index)
		forward_event(req, res, "/takeout", "entry")
	end
end
