require 'config'

class TabMenuItem
	def initialize(t, e)
		@enable   = true
		@selected = false
		@title    = t 
		@event    = e
	end

	attr_reader :title, :event
	attr_accessor :enable, :selected
end

class TabMenu
	
	attr_reader :menu_items

	def initialize(file_path)
		@menu_items = []

		file = open(file_path)
			file.each do |line| 
			t,e = line.split(",");
			@menu_items.push(TabMenuItem.new(t.chomp, e.chomp))
		end
		file.close

		# ԍŏ̃j[ACe̓ftHgőI
		@menu_items[0].selected = true
	end

	def enable_login
		@menu_items.each do |item|
			if item.event == "login" then
				item.enable = true
			elsif item.event == "logout" then
				item.enable = false
			end
		end
	end

	def enable_logout
		@menu_items.each do |item|
			if item.event == "login" then
				item.enable = false 
			elsif item.event == "logout" then
				item.enable = true
			end
		end
	end
	
	def select(req)
		event = req.path.sub(/\//, "")
		@menu_items.each do |item|
			if item.event == event then
				item.selected = true
			else
				item.selected = false
			end
		end
	end

end
