#import <Cocoa/Cocoa.h>

@interface AppController: NSObject
{
	NSTask* task;
	bool    taskWillTerminate;
}

- (void) initWithTask:(NSTask*) task;
- (void) applicationDidFinishLaunching:(NSNotification*)aNote;
- (void) applicationWillTerminate:(NSNotification*)aNote;
@end

@implementation AppController

- (void) initWithTask:(NSTask*)t
{
	[super init];
	task = t;
	taskWillTerminate = false;
}

/* ץ꽪λν */
- (void) applicationWillTerminate:(NSNotification*)aNote
{
	if(!taskWillTerminate && [[aNote name] isEqualToString:NSTaskDidTerminateNotification]) {
		NSRunAlertPanel(@"MalonAccount", @"MalonAccount has crashed!", @"OK", nil, nil);
		[NSApp terminate:nil];
	}
	else {
		taskWillTerminate = true;
		[task terminate];
		[task waitUntilExit];
	}
}

/* ץ굯ưλν */
- (void) applicationDidFinishLaunching:(NSNotification*)aNote
{
	sleep(5);
 	[[NSWorkspace sharedWorkspace] openURL:[NSURL URLWithString:@"http://localhost:50001/"]];
}

@end

int callRubyScript(NSTask* task, AppController* controller) { 

	NSMutableString* curPath  = [ NSMutableString string ];
	NSMutableString* scrPath  = [ NSMutableString string ]; 
    NSMutableString* logPath = [NSMutableString stringWithString:NSHomeDirectory()];

	// ե̾
    [logPath appendString:@"/Library/Logs/MalonAccount.log"];

	// եν
	[[ NSFileManager defaultManager] removeFileAtPath:logPath handler:nil];
	[[ NSFileManager defaultManager] createFileAtPath:logPath contents:nil attributes:nil];

	// ɸϤȥ顼Ϥ嵭Υեˤ
	NSFileHandle* fh = [NSFileHandle fileHandleForWritingAtPath:logPath];
	[task setStandardOutput:fh];
	[task setStandardError:fh];

	// Υ󥿡ؤϿ(RubyץȽλΤ)
	[ [ NSNotificationCenter defaultCenter ] addObserver:controller
                                                selector:@selector(applicationWillTerminate:)
                                                    name:NSTaskDidTerminateNotification
                                                  object:nil ];

	// ѥμ 
	[ curPath setString : [ [ NSBundle mainBundle ] bundlePath ] ];
	[ curPath appendString : @"/Contents/Resources" ]; 

	[ scrPath setString    : [ [ NSBundle mainBundle ] bundlePath ] ];
	[ scrPath appendString : @"/Contents/Resources/main.rb" ]; 

	// ¹ 

	[ task setLaunchPath           : @"/usr/bin/ruby" ];
	[ task setCurrentDirectoryPath : curPath ];
	[ task setArguments            : [ NSArray arrayWithObject : scrPath ] ];
	[ task launch ];
}

int main( int argc, const char *argv[] ) {

	NSAutoreleasePool* arp = [ [ NSAutoreleasePool alloc ] init ];
	NSTask* task;
  
	id app = [NSApplication sharedApplication];  
	[NSBundle loadNibNamed:@"malonApp" owner:app];

	/* ȥ */	
	task = [ [ NSTask alloc ] init ]; 
	id controller = [[AppController alloc] initWithTask: task];

	/* Rubyץȵư */	
	callRubyScript(task, controller);

	/* ȥ顼 */
	[app setDelegate: controller];

	[NSApp run];

	[ arp release ];
} 
