#!/usr/bin/ruby
$:.unshift('./lib')
require 'config'
require 'webrick'
require 'erb'
require 'controller'
require 'incomeModel'


include WEBrick
include ERB::Util

class IncomeController < Controller

	def initialize(server, *options)
		super
		@menu = TabMenu.new("account.menu")
		@income_model = nil
	end

	def init_income_model(req)
		if req.query["target_date"] == nil then
			today = Date.today
			@t_date = sprintf("%04d%02d%02d", today.year, today.month, today.day)
		else
			@t_date = req.query["target_date"]
		end
		@t_user = req.query["target_user"]
		@b_user = req.query["base_user"]
		@index  = req.query["index"].to_i

		@income_model = IncomeModel.new(@t_date, @t_user, @b_user)
	end

	def entry(req, res)
		init_income_model(req)
		set_view(req, res, "view/income.rhtml")
	end

	def add(req, res)
		init_income_model(req)
		record = IncomeRecord.new(nil)
		record.init_with_args(req.query["subject"],
                              req.query["price"],
                              req.query["source"])
		@income_model.add(record)
		forward_event(req, res, "/income", "entry")
	end
	
    def del(req, res)
		init_income_model(req)
		@income_model.delete(@index)
		forward_event(req, res, "/income", "entry")
	end

    def mod(req, res)
		init_income_model(req)
		record = IncomeRecord.new(nil)
		record.init_with_args(req.query["subject"],
                              req.query["price"],
                              req.query["source"])
		@income_model.modify(record, @index)
		forward_event(req, res, "/income", "entry")
	end
end
