require 'const'
require 'outgoModel'
require 'StrDate'


class HistModel

	include StrDate

	def initialize
		@value_list = Hash.new # {date => value}
	end

	#
	# start_date, end_date : yyyymmdd
	# model_name           : OutgoModelʤɤΥ饹̾
	# value_name           : 쥳ɤΥС̾
	# value                : Ȥʤ쥳ɤ
	# operator             : 黻᥽åɡ==, include?
	# integ                : "daily"->衢"monthly"->
	def init(start_date, end_date, model_name, value_name, value, operator, t_user, b_user, integ)
		@start_date_display = start_date                         # yyyy/mm/dd
		@end_date_display   = end_date                           # yyyy/mm/dd
		@start_date_str = start_date.delete("/") if(start_date)  # yyyymmdd
		@end_date_str   = end_date.delete("/") if(end_date)      # yyyymmdd
		@model_name     = model_name
		@value_name     = value_name
		if value_name == 'price' then
			@value          = value.to_i
		else
			@value          = value.to_s
		end
  		@operator       = operator
		@integ			= integ

		@start_date = str_to_date(start_date)
		@end_date   = str_to_date(end_date)

		@start_date.step(@end_date, 1) do |date|
			date_str    = sprintf("%04d%02d%02d",date.year, date.month, date.day)
			if integ == "daily" then
				date_index  = sprintf("%04d/%02d/%02d",date.year, date.month, date.day)
			else
				date_index  = sprintf("%04d/%02d",date.year, date.month)
			end
			model = eval("#{model_name}.new(date_str, t_user, b_user)")
			model.each do |record|
				if eval("record.#{value_name}.#{operator}(@value)") then
					if @value_list[date_index] == nil then
						@value_list[date_index] = record.price
					else		
						@value_list[date_index] += record.price
					end
				end
			end
		end
	end

	attr_reader :value_list
	attr_reader :start_date_str,
				:start_date_display,
				:end_date_str,
				:end_date_display,
				:model_name,
				:value_name,
				:value,
  				:operator,
				:integ

	def max_value
		max = 0
		@value_list.keys.sort.each do |key|
			if max < value_list[key].to_i then
				max = value_list[key].to_i
			end
		end
		return max
	end
	
	def sum_of_value
		sum = 0
		@value_list.keys.sort.each do |key|
			sum += value_list[key].to_i
		end
		return sum
	end
end

=begin TEST
#hist = HistModel.new('20040101', '20060501', 'OutgoModel', 'shop', '', 'include?', 'kakei', 'kakei')
hist = HistModel.new
hist.init('20040101', '20060501', 'OutgoModel', 'kind', '', 'include?', 'kakei', 'kakei', 'daily')

hist.value_list.keys.sort.each do |key|
	print key + " " + hist.value_list[key].to_i.to_s + "\n"
end

=end


