#!/usr/bin/ruby
$:.unshift('./lib')
require 'config'
require 'webrick'
require 'erb'
require 'controller'
require 'histModel'


include WEBrick
include ERB::Util

class HistController < Controller
	
	def initialize(server, *options)
		super
		@menu = TabMenu.new("account.menu")
		@outgo_model = nil
	end

	def init_model(req)
		t_user     = req.query["target_user"]
		b_user     = req.query["base_user"]
		s_date     = req.query["start_date"]
		e_date     = req.query["end_date"]
		value_name = req.query["value_name"]
		value      = req.query["value"]
		operator   = req.query["operator"]
		model_name = req.query["model_name"]
		integ      = req.query["integ_mode"]

		if s_date == "" or s_date == nil then
			@hist_model = HistModel.new
		else
			@hist_model = HistModel.new
			@hist_model.init(s_date, e_date, model_name, value_name, value, operator, t_user, b_user, integ)
		end

	end

	def entry(req, res)
		init_model(req)
		set_view(req, res, "view/history.rhtml")
	end
	
end
