#!/usr/bin/ruby
$:.unshift('./lib')
require 'config'
require 'webrick'
require 'erb'
require 'controller'
require 'listDataModel'


include WEBrick
include ERB::Util

class ConfigController < Controller
	
	def initialize(server, *options)
		super
		@menu = TabMenu.new("account.menu")
	end


	def init_model(req)
		@t_user = req.query["target_user"]
		@b_user = req.query["base_user"]
		@conf = Configuration.new(@t_user, @b_user)
		@kind_list_model   = @conf.kind_list
		@source_list_model = @conf.source_list
		@index  = req.query["index"].to_i
		@limit_day = @conf.limit_day
	end

	def entry(req, res)
		init_model(req)
		set_view(req, res, "view/config.rhtml")
	end
	
	def config_fail(req, res)
		init_model(req)
		set_view(req, res, "view/configfail.rhtml")
	end

	def add(req, res)
		init_model(req)
		record = ListRecord.new(nil)
		record.init_with_args(req.query["subject"])

		case req.query["list_name"]
		when "kind"
				@kind_list_model.add(record)

		when "source"
				@source_list_model.add(record)
		end
		forward_event(req, res, "/config", "entry")
	end

	def del(req, res)
		init_model(req)
		case req.query["list_name"]
		when "kind"
				@kind_list_model.delete(@index)

		when "source"
				@source_list_model.delete(@index)
		end
		forward_event(req, res, "/config", "entry")
	end

	def mod(req, res)
		init_model(req)
		record = ListRecord.new(nil)
		record.init_with_args(req.query["subject"])

		case req.query["list_name"]
		when "kind"
				@kind_list_model.modify(record, @index)

		when "source"
				@source_list_model.modify(record, @index)
		end
		forward_event(req, res, "/config", "entry")
	end

	def set_limit_day(req, res)
		init_model(req)
		begin
			@conf.limit_day = req.query["limit_day"].to_i
			forward_event(req, res, "/config", "entry")
		rescue
			forward_event(req, res, "/config", "config_fail")
		end
	end
end
