require 'config'
require 'date'
require 'parsedate'
require 'outgoModel'
require 'incomeModel'
require 'takeoutModel'
require 'StrDate'
require 'const'


class BalanceModel

	include StrDate

	def initialize(t_date, t_user, b_user, of_month = true)

		# Ώۓt
		@target_date = t_date

		# Ώۃ[U[
		@target_user = t_user
		
		# 샆[U[
		@base_user   = b_user

		@limit_day = Configuration.new(@target_user, @base_user).limit_day                 # ߓ擾

		# ꗗ
		# evfsubject,price,dateL[ƂnbVIuWFNg
		@income_list  = Array.new

		# oꗗ
		@takeout_list = Array.new
		
		# xoꗗ 
		# ʂL[ɂnbVŁAevfgoods,price,dateL[ƂnbVIuWFNg
		@outgo_list   = Hash.new
	

		# Wv(xoA̓ƍv)
		s_date = str_to_date(start_date)
		if of_month then # ̏Wv
			e_date = str_to_date(end_date)
		else              # (target_date)܂ł̏Wv
			e_date = str_to_date(@target_date)
		end

		@sum_of_income  = 0
		sum_of_takeout = 0
		sum_of_outgo   = 0
		s_date.step(e_date, 1) do |date|
			date_str  = sprintf("%04d%02d%02d",date.year, date.month, date.day)
			date_str2 = sprintf("%02d/%02d",date.month, date.day)

			# 
			income_model = IncomeModel.new(date_str, t_user, b_user)
			income_model.each do |record|
				@income_list.push({"subject"=>record.subject, "price"=>record.price, 
                                   "source" => record.source, "date"=>date_str, "date_short"=>date_str2})
			end
			@sum_of_income += income_model.sum_of_income

			# o
			takeout_model = TakeoutModel.new(date_str, t_user, b_user)
			takeout_model.each do |record|
				@takeout_list.push({"account_name"=>record.account_name, "price"=>record.price, 
                                    "date"=>date_str, "date_short"=>date_str2})
			end
			sum_of_takeout += takeout_model.sum_of_takeout

			# xo
			outgo_model = OutgoModel.new(date_str, t_user, b_user)
			outgo_model.each do |record|
				if @outgo_list[record.kind] == nil then
					@outgo_list[record.kind] = Array.new
				end
				@outgo_list[record.kind].push({"goods"=>record.goods, "price"=>record.price, 
                                               "source"=>record.source, "date"=>date_str, "date_short"=>date_str2})
			end
			sum_of_outgo += outgo_model.sum_of_outgo

			
		end

		# ov
		@sum_of_takeout = sum_of_takeout

		# xov
		@sum_of_outgo = sum_of_outgo
		
		# ʂƂ̎xov
		@sum_of_outgo_by_kind   = Hash.new
		@outgo_list.each do |key, list|
			list.each do |outgo_data|
				if @sum_of_outgo_by_kind[key] == nil then 
					@sum_of_outgo_by_kind[key] = outgo_data["price"]
				else
					@sum_of_outgo_by_kind[key] += outgo_data["price"]
				end
			end
		end

		# cizÃXgj
		@balance = Hash.new
		@income_list.each do |income_data|    # lƂ
			source = income_data["source"]
			if @balance[source] == nil then
				@balance[source] = income_data["price"]
			else
				@balance[source] += income_data["price"]
			end
		end	

		@takeout_list.each do |takeout_data|  # o獷AzɉZ
			source = takeout_data["account_name"]
			if @balance[source] == nil then
				@balance[source] = -takeout_data["price"]
			else
				@balance[source] -= takeout_data["price"]
				if  @balance[Const::WALLET] == nil then
					@balance[Const::WALLET] = takeout_data["price"]
				else
					@balance[Const::WALLET] += takeout_data["price"]
				end
			end
		end

		@outgo_list.each do |key, list|       # ƂAzgAz獷
			list.each do |outgo_data|
				source = outgo_data["source"]
				if @balance[source] == nil then
					@balance[source] = -outgo_data["price"]
				else
					@balance[source] -= outgo_data["price"]
				end
			end
		end
	end


	# Ώۓtw肷錎̍ŏ̓Ԃiߓlj
	def start_date
		date = str_to_date(@target_date)
		if date.day <= @limit_day then
			date = str_to_date(@target_date) << 1                              # Ώۓ̂POZo
		end
		date_str = sprintf("%04d%02d%02d", date.year, date.month, @limit_day)  # ߓɂ
		date = str_to_date(date_str) + 1                                       # ߓ̗Jn
		return sprintf("%04d%02d%02d", date.year, date.month, date.day)
	end



	# Ώۓtw肷錎̍Ō̓Ԃ
	def end_date
		date = str_to_date(@target_date)
		if date.day > @limit_day then
			date = str_to_date(@target_date) >> 1                              # Ώۓ̂PZo
		end
		date_str = sprintf("%04d%02d%02d", date.year, date.month, @limit_day)  # ߓɂ
		return date_str
	end

	attr_reader :income_list, :sum_of_outgo, :outgo_list, :takeout_list, :balance_of_today, :balance
	attr_reader :sum_of_takeout, :sum_of_outgo_by_kind, :target_date, :sum_of_income
end

=begin TEST

model = BalanceModel.new('20060123', 'kakei', 'kakei', false)

# ꗗ
model.income_list.each do |record|
	print "#{record["subject"]}, #{record["price"]}, #{record["date"]}\n"
end

# xoꗗ
model.outgo_list.each do |key, list|
	print "\n[#{key}]\n"
	list.each do |record|
		print "    #{record["goods"]}, #{record["price"]}, #{record["source"]}, #{record["date"]}\n"
	end
end

# xov
print "\nsum_of_outgo: #{model.sum_of_outgo}\n\n"

# c
model.balance.each do |key, record|
	print "#{key}, #{record}\n"
end
=end

