# coding: UTF-8

require 'plugin/weblog/lib/standard_edit'
require 'plugin/weblog/atom_pub/lib/atom_pub_weblog_post_common'

#=AtomPub を使った標準のブログ編集投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: atom_pub_edit.rb 941 2013-01-08 06:41:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class AtomPubEdit_WeblogPlugin < StandardEdit_WeblogPlugin
	include AtomPubWeblogPostCommon

	def edit_article(client, postid, header, dateCreated)
		@logger.debug("Start  AtomPub.update_entry ... entry_uri = #{@parent.entry_collection_uri}/#{postid}") if @logger && @logger.debug?
		entry = {}
		entry[:title] = header['title'].encode('BINARY', 'BINARY') if header['title']
		entry[:content] = header['description'].encode('BINARY', 'BINARY') if header['description']
		update_entry = Atom::Entry.new(entry)
		@logger.debug("entry = #{update_entry.to_s}") if @logger && @logger.debug?
		entry_uri = client.update_entry("#{@parent.entry_collection_uri}/#{postid}", update_entry)
		@logger.debug("Finish AtomPub.update_entry ... entry_uri = #{entry_uri}") if @logger && @logger.debug?
	end

end
