# coding: UTF-8

#=書式プラグイン用ユーティリティ
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: format_plugin_utils.rb 941 2013-01-08 06:41:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
module FormatPluginUtils

	def get_format_plugin_parameter(param, vars, required_param_count = 0, option_alias = {}, option_default = {})
		@logger.debug("Start  #{self.class.name}#get_format_plugin_parameter ... param = #{param}, vars = #{vars.to_s}, required_param_count = #{required_param_count}, option_alias = #{option_alias.to_s}, option_default = #{option_default.to_s}") if @logger && @logger.debug?
		(params, param_option, content) = __parse_param(param, vars, required_param_count)
		@logger.debug("Start  #{self.class.name}#get_format_plugin_parameter ... param = #{param}, vars = #{vars.to_s}, required_param_count = #{required_param_count}, option_alias = #{option_alias.to_s}, option_default = #{option_default.to_s}") if @logger && @logger.debug?

		option = {}

		# デフォルト値
		__merge_option(option, option_default, option_alias, vars)

		# プラグインの設定
		__merge_option(option, __remove_format_plugin_conf(vars[M2W_FORMAT_PLUGIN_CONF_NAME]), option_alias, vars)

		# ヘッダーの設定
		__merge_option(option, __parse_header_option(vars), option_alias, vars)

		# プラグインのパラメータ指定
		__merge_option(option, param_option, option_alias, vars)

		@logger.debug("Finish #{self.class.name}#get_format_plugin_parameter ... params = #{params.to_s}, option = #{option.to_s}") if @logger && @logger.debug?
		return [params, option, content]
	end

	def __parse_param(param, vars, required_param_count = 0)
		@logger.debug("Start  #{self.class.name}#__parse_param ... param = #{param}, vars = #{vars.to_s}, required_param_count = #{required_param_count}") if @logger && @logger.debug?
		param_separator = format_plugin_common_conf(vars, M2W_FORMAT_PLUGIN_COMMON_CONF_PARAM_SEPARATOR_NAME)
		quote_char = format_plugin_common_conf(vars, M2W_FORMAT_PLUGIN_COMMON_CONF_QUOTE_CHAR_NAME)

		@logger.debug("get_conf: param_separator = #{param_separator}, quote_char = #{quote_char}") if @logger && @logger.debug?

		content = nil
		# 複数行であることを判断する
		if param =~ /(\r|\n)/ then
			# 複数行だった場合は、先頭行をパラメータ／以降をコンテンツと判断する
			(first_param, content) = param.split(/\r\n|\r|\n/, 2)
			@logger.debug("multiline: first_param = #{first_param}") if @logger && @logger.debug?
			params_array = __parse_csv(first_param, param_separator, quote_char)
		else
			params_array = __parse_csv(param, param_separator, quote_char)
		end

		@logger.debug("parsed: #{params_array.to_s}") if @logger && @logger.debug?

		if params_array.size < required_param_count then
			raise FormatPluginError.new(
				"引数不足(必要数 = #{required_param_count}, 実質数 = #{params_array.size})",
				"引数が足りませんでした（必要数 = #{required_param_count}, 実質数 = #{params_array.size}）。")
		end

		@logger.debug("Finish #{self.class.name}#__parse_param") if @logger && @logger.debug?
		return [params_array[0, required_param_count], __get_option(params_array[required_param_count, params_array.size], vars), content]
	end

	def __remove_format_plugin_conf(vars)
		if vars != nil then
			result = vars.clone
			result.delete(M2W_FORMAT_PLUGIN_CONF_HEADER_NAME)
			result.delete(M2W_FORMAT_PLUGIN_NAME)
			return result
		else
			return nil
		end
	end

	def __parse_header_option(vars)
		@logger.debug("Start  #{self.class.name}#__parse_header_option ... vars = #{vars.to_s}") if @logger && @logger.debug?
		param_separator = format_plugin_common_conf(vars, M2W_FORMAT_PLUGIN_COMMON_CONF_PARAM_SEPARATOR_NAME)
		quote_char = format_plugin_common_conf(vars, M2W_FORMAT_PLUGIN_COMMON_CONF_QUOTE_CHAR_NAME)

		result = {}
		if vars[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME] != nil &&
				vars[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME].has_key?(vars[M2W_FORMAT_PLUGIN_CONF_NAME][M2W_FORMAT_PLUGIN_NAME]) then
			result = __get_option(__parse_csv(vars[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME][vars[M2W_FORMAT_PLUGIN_CONF_NAME][M2W_FORMAT_PLUGIN_NAME]], param_separator, quote_char), vars)
		end

		@logger.debug("Finish #{self.class.name}#__parse_header_option ... result = #{result.to_s}") if @logger && @logger.debug?
		return result
	end

	def format_plugin_conf(vars, key)
		conf = vars[M2W_FORMAT_PLUGIN_CONF_NAME]

		if conf != nil then
			return conf[key]
		else
			return nil
		end
	end

	def __parse_csv(line, param_separator, quote_char)
		result = []
	
		state = 1
		i = 0
		buffer = ""
		while i < line.length
			str = line[i]
	
			case state
			when 1  # head
				case str
				when quote_char[0]
					state = 3  # quoting
				when param_separator[0]
					result.push(buffer)
					buffer = ""
					# next data
				else
					buffer << str
					state = 2  # no_quote
				end
			when 2  # no_quote
				case str
				when param_separator[0]
					result.push(buffer)
					buffer = ""
					state = 1  # head
					# next data
				else
					buffer << str
				end
			when 3  # quoting
				case str
				when quote_char[0]
					state = 4  # quote_end
				else
					buffer << str
				end
			when 4
				case str
				when quote_char[0]
					buffer << str
					state = 3
				when param_separator[0]
					result.push(buffer)
					buffer = ""
					state = 1	# head
					# next data
				else
					raise FormatPluginError.new(
						"引数書式不正(引数 = #{line})",
						"引数の囲みが正常に閉じられていません（引数 = #{line}）。")
				end
			end
	
			i = i + 1
		end
	
		if state == 3 then
			raise FormatPluginError.new(
				"引数書式不正(引数 = #{line})",
				"引数の囲みが正常に閉じられていません（引数 = #{line}）。")
		else
			result.push(buffer)
		end
	
		return result
	end

	def __get_option(params, vars)
		option_separator = format_plugin_common_conf(vars, M2W_FORMAT_PLUGIN_COMMON_CONF_OPTION_SEPARATOR_NAME)

		result = {}
		params.each do |param|
			(key, value) = param.split(option_separator, 2)
			result[key] = value
		end

		return result
	end

	def __merge_option(result, target, option_alias, vars)
		option_delete_mark = format_plugin_common_conf(vars, M2W_FORMAT_PLUGIN_COMMON_CONF_OPTION_DELETE_MARK_NAME)

		if target != nil then
			target.each do |key, value|
				if /(#{option_delete_mark})?(.+)$/ =~ key then
					option_delete_flug = $1
					option_key = $2
					real_key = option_alias.has_key?(option_key) ? option_alias[option_key] : option_key
					if option_delete_flug != option_delete_mark then
						result[real_key] = value
					else
						result.delete(real_key)
					end
				end
			end
		end
	end

	def format_plugin_common_conf(vars, key)
		conf = vars[M2W_FORMAT_PLUGIN_COMMON_CONF_NAME]

		result = nil
		if conf != nil then
			result = conf[key]
		end

		if result != nil then
			return result
		else
			return M2W_FORMAT_PLUGIN_CONF_DEFAULT_VALUE[key]
		end
	end

	def set_format_plugin_common_conf(vars, value)
		if value != nil then
			vars[M2W_FORMAT_PLUGIN_COMMON_CONF_NAME] = value
		end
	end

	def set_format_plugin_conf(vars, value)
		if value != nil then
			vars[M2W_FORMAT_PLUGIN_CONF_NAME] = value
		end
	end

end
