# coding: UTF-8

require 'plugin/command/adapter/mail/lib/standard_command_adapter4mail'

#=ブログ記事編集コマンドアダプタープラグイン（メール用）
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: edit.rb 941 2013-01-08 06:41:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Edit_CommandAdapterPlugin4Mail < Standard_CommandAdapterPlugin4Mail

	def create_response(command, request, response)
		return response.success ? create_success_response(command, request, response) : create_failure_response(command, request, response)
	end

	def create_success_response(command, request, response)
content = <<"END_CONTENT"
ブログ記事の編集に成功しました。

編集したブログ記事を編集したい場合は、本メールをそのまま返信すると編集用のメールが届きます。

投稿したブログ記事を削除したい場合は、タイトルを m.get から m.delete に変更して返信してください。
#{make_exception_contents(response)}
END_CONTENT

		response.notices.push(Mail2WeblogResponseNotice.new(
			:destination => request.source,
			:type => 'get',
			:param => request.param,
			:header => {"postid" => response[:postid]},
			:content => content
		))
		return response
	end

	def create_failure_response(command, request, response)
content = <<"END_CONTENT"
ブログ記事の編集に失敗しました。
#{make_exception_contents(response)}
END_CONTENT

		response.notices.push(Mail2WeblogResponseNotice.new(
			:destination => request.source,
			:type => 'error',
			:param => request.param,
			:content => content
		))
		return response
	end

end
