#!/usr/bin/ruby
# coding: UTF-8

require 'clockwork'
include Clockwork

#=mail2weblog の clockwork 版エントリーポイント
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: m2w4clockwork.rb 945 2013-01-20 11:18:43Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = File.dirname(File.expand_path(__FILE__))

# LOAD_PATH に必要なフォルダを追加する
$:.unshift(M2W_ROOT_PATH + "/")
$:.unshift(M2W_ROOT_PATH + "/lib")

require 'm2w_configurator'
require 'm2w_runner'

handler do |runner|
	begin
		runner.run(M2W_SYSTEM_CONTINOUS_PROCESSING, M2W_SYSTEM_MAIL_RECEIVER_SLEEPING_TIME)
	rescue Mail2WeblogTimeout => tout
		M2W_LOGGER.info(tout.message)
		puts "Succeeded ... timeout"
		exit(0)
	rescue => e
		M2W_LOGGER.error(e)
		puts "Failed ... #{e.message}"
		exit(1)
	end
end

# runner を clockwork ジョブとして定義する
runner = Mail2WeblogRunner.new()
every((M2W_SYSTEM_PROCESSING_TIME != nil && 0 < M2W_SYSTEM_PROCESSING_TIME) ? M2W_SYSTEM_PROCESSING_TIME.seconds : 10.seconds, runner)
