/*
 *  MAGRO: MCMC Another Gibbs Sampler
 *
 *  Copyright (C) 2010 Wataru Uda
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __ENV_H__
#define __ENV_H__

#include "node.h"

typedef struct _ENV ENV;

struct _ENV {
    int count;
	int size; 
	char** names;
    NODE** nodes;
    ENV* parent;
};

ENV* env_create(ENV* parent);
void env_free(ENV* env);
int env_getindex(ENV* env, const char* name);
void env_setsymbol(ENV* env, const char* name, NODE* node);

NODE* env_find(ENV* env, const char* name);
char* env_getenvstring(const char* name);

ENV* env_stackout(ENV* env);
ENV* env_stackin(ENV* env);

#endif
