-- *
-- * 標準テーブル作成スクリプト
-- *
-- * PHP versions 5
-- *
-- * LICENSE: This source file is licensed under the terms of the GNU General Public License.
-- *
-- * @package    Magic3 Framework
-- * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
-- * @copyright  Copyright 2006-2009 Magic3 Project.
-- * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
-- * @version    SVN: $Id: create_std.sql 2704 2009-12-17 09:56:21Z fishbone $
-- * @link       http://www.magic3.org
-- *
-- --------------------------------------------------------------------------------------------------
-- 標準テーブル作成スクリプト
-- システムの標準構成で必要なテーブルの作成を行う
-- --------------------------------------------------------------------------------------------------

-- 国マスター
DROP TABLE IF EXISTS country;
CREATE TABLE country (
    ct_id                VARCHAR(3)     DEFAULT ''                    NOT NULL,      -- 国ID(ISO 3文字コード)
    ct_language_id       VARCHAR(2)     DEFAULT ''                    NOT NULL,      -- 言語ID
    ct_name              VARCHAR(20)    DEFAULT ''                    NOT NULL,      -- 国名称
    ct_name_short        VARCHAR(15)    DEFAULT ''                    NOT NULL,      -- 国名称略称
    ct_iso_code_2        VARCHAR(2)     DEFAULT ''                    NOT NULL,      -- ISO 2文字コード
    ct_index             INT            DEFAULT 0                     NOT NULL,      -- ソート用
    PRIMARY KEY          (ct_id,        ct_language_id)
) TYPE=innodb;

-- 通貨マスター
DROP TABLE IF EXISTS currency;
CREATE TABLE currency (
    cu_id                VARCHAR(3)     DEFAULT ''                    NOT NULL,      -- 通貨ID
    cu_language_id       VARCHAR(2)     DEFAULT ''                    NOT NULL,      -- 言語ID
    cu_name              VARCHAR(20)    DEFAULT ''                    NOT NULL,      -- 名称
    cu_description       VARCHAR(80)    DEFAULT ''                    NOT NULL,      -- 説明
    cu_symbol            VARCHAR(20)    DEFAULT ''                    NOT NULL,      -- 表示記号
    cu_post_symbol       VARCHAR(20)    DEFAULT ''                    NOT NULL,      -- 後表示記号
    cu_decimal_place     INT            DEFAULT 0                     NOT NULL,      -- 小数以下桁数
    cu_index             INT            DEFAULT 0                     NOT NULL,      -- ソート用
    PRIMARY KEY          (cu_id,        cu_language_id)
) TYPE=innodb;

-- メニューマスター
DROP TABLE IF EXISTS menu;
CREATE TABLE menu (
    me_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    me_id                VARCHAR(20)    DEFAULT ''                    NOT NULL,      -- メニューID
    me_language_id       VARCHAR(2)     DEFAULT ''                    NOT NULL,      -- 言語ID
    me_name              VARCHAR(30)    DEFAULT ''                    NOT NULL,      -- 名前
    me_type              INT            DEFAULT 0                     NOT NULL,      -- メニューのタイプ(0=テーブル,1=リスト)
    me_show_name         BOOLEAN        DEFAULT true                  NOT NULL,      -- 名前を表示するかどうか
    me_params            TEXT                                         NOT NULL,      -- 各種パラメータ
    me_style             TEXT                                         NOT NULL,      -- HTMLスタイル属性

    me_checked_out       BOOLEAN        DEFAULT false                 NOT NULL,      -- チェックアウト中かどうか
    me_checked_out_dt    TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- チェックアウト日時
    me_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    me_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    PRIMARY KEY          (me_serial),
    UNIQUE               (me_id,        me_language_id)
) TYPE=innodb;

-- メニュー項目マスター
DROP TABLE IF EXISTS menu_item;
CREATE TABLE menu_item (
    mi_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    mi_id                INT            DEFAULT 0                     NOT NULL,      -- 項目ID
    mi_language_id       VARCHAR(2)     DEFAULT ''                    NOT NULL,      -- 言語ID
    mi_menu_id           VARCHAR(20)    DEFAULT ''                    NOT NULL,      -- 項目が所属するメニューID
    mi_index             INT            DEFAULT 0                     NOT NULL,      -- メニュー上での項目番号(0～)
    mi_submenu_id        VARCHAR(20)    DEFAULT ''                    NOT NULL,      -- サブメニューID
    mi_name              VARCHAR(30)    DEFAULT ''                    NOT NULL,      -- 名前
    mi_type              INT            DEFAULT 0                     NOT NULL,      -- 項目タイプ(0=通常リンク、1=JavaScript)
    mi_link_type         INT            DEFAULT 0                     NOT NULL,      -- リンクタイプ(0=同ウィンドウ、1=別ウィンドウ)
    mi_link_url          TEXT                                         NOT NULL,      -- リンク先
    mi_param             TEXT                                         NOT NULL,      -- その他パラメータ
    mi_style             TEXT                                         NOT NULL,      -- CSS
    mi_select_param      TEXT                                         NOT NULL,      -- 選択状態を判断するためのパラメータ
    mi_visible           BOOLEAN        DEFAULT true                  NOT NULL,      -- 表示するかどうか
    mi_enable            BOOLEAN        DEFAULT true                  NOT NULL,      -- 使用可能かどうか
    mi_show_name         BOOLEAN        DEFAULT true                  NOT NULL,      -- 名前を表示するかどうか
    mi_access_id         INT            DEFAULT 0                     NOT NULL,      -- アクセス頻度調査用

    mi_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    mi_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    PRIMARY KEY          (mi_serial),
    UNIQUE               (mi_id,        mi_language_id)
) TYPE=innodb;

-- コンテンツ(検索対象となる)マスター
DROP TABLE IF EXISTS content;
CREATE TABLE content (
    cn_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    cn_type              VARCHAR(20)    DEFAULT ''                    NOT NULL,      -- コンテンツタイプ
    cn_id                INT            DEFAULT 0                     NOT NULL,      -- コンテンツID
    cn_language_id       VARCHAR(2)     DEFAULT ''                    NOT NULL,      -- 言語ID
    cn_history_index     INT            DEFAULT 0                     NOT NULL,      -- 履歴管理用インデックスNo(0～)
    cn_name              VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- コンテンツ名
    cn_description       VARCHAR(100)   DEFAULT ''                    NOT NULL,      -- 説明
    cn_html              TEXT                                         NOT NULL,      -- コンテンツHTML
    cn_meta_title        TEXT                                         NOT NULL,      -- METAタグ、タイトル
    cn_meta_description  TEXT                                         NOT NULL,      -- METAタグ、ページ要約
    cn_meta_keywords     TEXT                                         NOT NULL,      -- METAタグ、検索用キーワード
    cn_disp_type         SMALLINT       DEFAULT 0                     NOT NULL,      -- 表示タイプ(0=プレーン、1=インナーフレーム)
    cn_visible           BOOLEAN        DEFAULT true                  NOT NULL,      -- 表示可否
    cn_active_start_dt   TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 表示可能期間(開始)
    cn_active_end_dt     TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 表示可能期間(終了)
    cn_default           BOOLEAN        DEFAULT false                 NOT NULL,      -- デフォルトフラグ
    cn_key               VARCHAR(20)    DEFAULT ''                    NOT NULL,      -- 外部からの参照用キー
    cn_user_limited      BOOLEAN        DEFAULT false                 NOT NULL,      -- 参照ユーザを制限
    
    cn_check_out_user_id INT            DEFAULT 0                     NOT NULL,      -- チェックアウトユーザID(0のときはチェックイン状態)
    cn_check_out_dt      TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- チェックアウト日時
    cn_create_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード作成者
    cn_create_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード作成日時
    cn_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    cn_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    cn_locked            BOOLEAN        DEFAULT false                 NOT NULL,      -- レコードロック状態
    cn_deleted           BOOLEAN        DEFAULT false                 NOT NULL,      -- レコード削除状態
    PRIMARY KEY          (cn_serial),
    UNIQUE               (cn_type,      cn_id,        cn_language_id,               cn_history_index)
) TYPE=innodb;

-- ニュースコンテンツトラン
DROP TABLE IF EXISTS news;
CREATE TABLE news (
    nw_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    nw_type              VARCHAR(20)    DEFAULT ''                    NOT NULL,      -- コンテンツタイプ
    nw_server_id         CHAR(32)       DEFAULT ''                    NOT NULL,      -- サーバ識別ID
    nw_regist_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 登録日時

    nw_name              TEXT                                         NOT NULL,      -- コンテンツ名
    nw_link              TEXT                                         NOT NULL,      -- コンテンツリンク先
    nw_content_dt        TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- コンテンツ更新日時
    nw_message           TEXT                                         NOT NULL,      -- メッセージ
    nw_site_name         TEXT                                         NOT NULL,      -- サイト名
    nw_site_link         TEXT                                         NOT NULL,      -- サイトリンク

    nw_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    nw_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    nw_deleted           BOOLEAN        DEFAULT false                 NOT NULL,      -- レコード削除状態
    PRIMARY KEY          (nw_serial)
) TYPE=innodb;

-- Wiki設定マスター
DROP TABLE IF EXISTS wiki_config;
CREATE TABLE wiki_config (
    wg_id                VARCHAR(30)    DEFAULT ''                    NOT NULL,      -- ID(Key)
    wg_value             TEXT                                         NOT NULL,      -- 値
    wg_name              VARCHAR(50)    DEFAULT ''                    NOT NULL,      -- 名称
    wg_description       VARCHAR(80)    DEFAULT ''                    NOT NULL,      -- 説明
    wg_index             INT            DEFAULT 0                     NOT NULL,      -- ソート用
    PRIMARY KEY          (wg_id)
) TYPE=innodb;

-- Wikiコンテンツマスター
DROP TABLE IF EXISTS wiki_content;
CREATE TABLE wiki_content (
    wc_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    wc_type              VARCHAR(20)    DEFAULT ''                    NOT NULL,      -- コンテンツタイプ
    wc_id                VARCHAR(200)   DEFAULT ''                    NOT NULL,      -- コンテンツID
    wc_history_index     INT            DEFAULT 0                     NOT NULL,      -- 履歴管理用インデックスNo(0～)
    wc_data              TEXT                                         NOT NULL,      -- コンテンツ内容
    wc_content_dt        TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- コンテンツ更新日時
    wc_visible           BOOLEAN        DEFAULT true                  NOT NULL,      -- 表示可否
    wc_fore_serial       INT            DEFAULT 0                     NOT NULL,      -- 前レコードシリアル番号
    wc_next_serial       INT            DEFAULT 0                     NOT NULL,      -- 次レコードシリアル番号
    
    wc_check_out_user_id INT            DEFAULT 0                     NOT NULL,      -- チェックアウトユーザID(0のときはチェックイン状態)
    wc_check_out_dt      TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- チェックアウト日時
    wc_create_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード作成者
    wc_create_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード作成日時
    wc_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    wc_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    wc_locked            BOOLEAN        DEFAULT false                 NOT NULL,      -- レコードロック状態
    wc_deleted           BOOLEAN        DEFAULT false                 NOT NULL,      -- レコード削除状態
    PRIMARY KEY          (wc_serial),
    UNIQUE               (wc_type,      wc_id,  wc_history_index)
) TYPE=innodb;

-- ブログ設定マスター
DROP TABLE IF EXISTS blog_config;
CREATE TABLE blog_config (
    bg_id                VARCHAR(30)    DEFAULT ''                    NOT NULL,      -- ID(Key)
    bg_value             TEXT                                         NOT NULL,      -- 値
    bg_name              VARCHAR(50)    DEFAULT ''                    NOT NULL,      -- 名称
    bg_description       VARCHAR(80)    DEFAULT ''                    NOT NULL,      -- 説明
    bg_index             INT            DEFAULT 0                     NOT NULL,      -- ソート用
    PRIMARY KEY          (bg_id)
) TYPE=innodb;

-- ブログカテゴリマスター
DROP TABLE IF EXISTS blog_category;
CREATE TABLE blog_category (
    bc_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    bc_id                INT            DEFAULT 0                     NOT NULL,      -- カテゴリID
    bc_language_id       VARCHAR(2)     DEFAULT ''                    NOT NULL,      -- 言語ID
    bc_history_index     INT            DEFAULT 0                     NOT NULL,      -- 履歴管理用インデックスNo(0～)

    bc_name              VARCHAR(30)    DEFAULT ''                    NOT NULL,      -- カテゴリ名称
    bc_parent_id         INT            DEFAULT 0                     NOT NULL,      -- 親カテゴリID
    bc_sort_order        INT            DEFAULT 0                     NOT NULL,      -- ソート用
    bc_visible           BOOLEAN        DEFAULT true                  NOT NULL,      -- 表示するかどうか

    bc_create_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード作成者
    bc_create_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード作成日時
    bc_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    bc_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    bc_deleted           BOOLEAN        DEFAULT false                 NOT NULL,      -- レコード削除状態
    PRIMARY KEY          (bc_serial),
    UNIQUE               (bc_id,        bc_language_id,               bc_history_index)
) TYPE=innodb;

-- ブログエントリー(記事)マスター
DROP TABLE IF EXISTS blog_entry;
CREATE TABLE blog_entry (
    be_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    be_id                INT            DEFAULT 0                     NOT NULL,      -- エントリーID
    be_language_id       VARCHAR(2)     DEFAULT ''                    NOT NULL,      -- 言語ID
    be_history_index     INT            DEFAULT 0                     NOT NULL,      -- 履歴管理用インデックスNo(0～)
    
    be_name              VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- エントリータイトル
    be_html              TEXT                                         NOT NULL,      -- エントリー本文HTML
    be_html_ext          TEXT                                         NOT NULL,      -- エントリー本文HTML(続き)
    be_description       VARCHAR(100)   DEFAULT ''                    NOT NULL,      -- 概要
    be_status            SMALLINT       DEFAULT 0                     NOT NULL,      -- エントリー状態(0=未設定、1=編集中、2=公開、3=非公開)
    be_search_tag        VARCHAR(100)   DEFAULT ''                    NOT NULL,      -- 検索用タグ(「,」区切り)
    be_theme_id          VARCHAR(20)    DEFAULT ''                    NOT NULL,      -- ブログテーマID
    be_regist_user_id    INT            DEFAULT 0                     NOT NULL,      -- エントリー作者
    be_regist_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 投稿日時
    be_active_start_dt   TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 公開期間(開始)
    be_active_end_dt     TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 公開期間(終了)

    be_check_out_user_id INT            DEFAULT 0                     NOT NULL,      -- チェックアウトユーザID(0のときはチェックイン状態)
    be_check_out_dt      TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- チェックアウト日時
    be_create_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード作成者
    be_create_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード作成日時
    be_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    be_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    be_deleted           BOOLEAN        DEFAULT false                 NOT NULL,      -- レコード削除状態
    PRIMARY KEY          (be_serial),
    UNIQUE               (be_id,        be_language_id,               be_history_index)
) TYPE=innodb;

-- ブログ記事とブログ記事カテゴリーの対応付けマスター
DROP TABLE IF EXISTS blog_entry_with_category;
CREATE TABLE blog_entry_with_category (
    bw_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    bw_entry_serial      INT            DEFAULT 0                     NOT NULL,      -- ブログ記事シリアル番号
    bw_index             INT            DEFAULT 0                     NOT NULL,      -- インデックス番号
    bw_category_id       INT            DEFAULT 0                     NOT NULL,      -- ブログ記事カテゴリーID
    PRIMARY KEY          (bw_serial),
    UNIQUE               (bw_entry_serial,      bw_index)
) TYPE=innodb;

-- ブログコメントトラン
DROP TABLE IF EXISTS blog_comment;
CREATE TABLE blog_comment (
    bo_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    bo_entry_id          INT            DEFAULT 0                     NOT NULL,      -- エントリーID
    bo_language_id       VARCHAR(2)     DEFAULT ''                    NOT NULL,      -- 言語ID
    bo_parent_serial     INT            DEFAULT 0                     NOT NULL,      -- 親コメントのシリアル番号
    bo_user_id           INT            DEFAULT 0                     NOT NULL,      -- ユーザID
    bo_regist_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 投稿日時
    
    bo_name              VARCHAR(50)    DEFAULT ''                    NOT NULL,      -- タイトル
    bo_html              VARCHAR(200)   DEFAULT ''                    NOT NULL,      -- 本文HTML
    bo_url               TEXT                                         NOT NULL,      -- 参照用URL
    bo_user_name         VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- ユーザ名
    bo_email             VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- Eメールアドレス
    bo_status            SMALLINT       DEFAULT 0                     NOT NULL,      -- 状態(0=未設定、1=非公開、2=公開)
    
    bo_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    bo_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    bo_deleted           BOOLEAN        DEFAULT false                 NOT NULL,      -- レコード削除状態
    PRIMARY KEY          (bo_serial)
) TYPE=innodb;

-- BBS設定マスター
DROP TABLE IF EXISTS bbs_config;
CREATE TABLE bbs_config (
    sf_id                VARCHAR(30)    DEFAULT ''                    NOT NULL,      -- ID(Key)
    sf_value             TEXT                                         NOT NULL,      -- 値
    sf_name              VARCHAR(50)    DEFAULT ''                    NOT NULL,      -- 名称
    sf_description       VARCHAR(80)    DEFAULT ''                    NOT NULL,      -- 説明
    sf_index             INT            DEFAULT 0                     NOT NULL,      -- ソート用
    PRIMARY KEY          (sf_id)
) TYPE=innodb;

-- BBSカテゴリマスター
DROP TABLE IF EXISTS bbs_category;
CREATE TABLE bbs_category (
    sr_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    sr_id                INT            DEFAULT 0                     NOT NULL,      -- カテゴリID
    sr_language_id       VARCHAR(2)     DEFAULT ''                    NOT NULL,      -- 言語ID
    sr_history_index     INT            DEFAULT 0                     NOT NULL,      -- 履歴管理用インデックスNo(0～)

    sr_name              VARCHAR(30)    DEFAULT ''                    NOT NULL,      -- カテゴリ名称
    sr_sort_order        INT            DEFAULT 0                     NOT NULL,      -- ソート用
    sr_visible           BOOLEAN        DEFAULT true                  NOT NULL,      -- 表示するかどうか

    sr_create_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード作成者
    sr_create_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード作成日時
    sr_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    sr_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    sr_deleted           BOOLEAN        DEFAULT false                 NOT NULL,      -- レコード削除状態
    PRIMARY KEY          (sr_serial),
    UNIQUE               (sr_id,        sr_language_id,               sr_history_index)
) TYPE=innodb;

-- BBSグループマスター
DROP TABLE IF EXISTS bbs_group;
CREATE TABLE bbs_group (
    sg_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    sg_id                INT            DEFAULT 0                     NOT NULL,      -- グループID
    sg_language_id       VARCHAR(2)     DEFAULT ''                    NOT NULL,      -- 言語ID
    sg_history_index     INT            DEFAULT 0                     NOT NULL,      -- 履歴管理用インデックスNo(0～)

    sg_name              VARCHAR(30)    DEFAULT ''                    NOT NULL,      -- グループ名称
    sg_sort_order        INT            DEFAULT 0                     NOT NULL,      -- ソート用
    sg_editable          BOOLEAN        DEFAULT true                  NOT NULL,      -- データの編集許可

    sg_create_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード作成者
    sg_create_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード作成日時
    sg_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    sg_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    sg_deleted           BOOLEAN        DEFAULT false                 NOT NULL,      -- レコード削除状態
    PRIMARY KEY          (sg_serial),
    UNIQUE               (sg_id,        sg_language_id,               sg_history_index)
) TYPE=innodb;

-- BBS記事マスター
DROP TABLE IF EXISTS bbs_thread;
CREATE TABLE bbs_thread (
    se_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    se_id                INT            DEFAULT 0                     NOT NULL,      -- エントリーID
    se_language_id       VARCHAR(2)     DEFAULT ''                    NOT NULL,      -- 言語ID
    se_history_index     INT            DEFAULT 0                     NOT NULL,      -- 履歴管理用インデックスNo(0～)
    
    se_name              VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- タイトル
    se_html              TEXT                                         NOT NULL,      -- 本文HTML
    se_status            SMALLINT       DEFAULT 0                     NOT NULL,      -- 記事状態(0=未設定、1=保留、2=表示、3=非表示)
    se_closed            BOOLEAN        DEFAULT false                 NOT NULL,      -- 投稿終了状態
    se_level             INT            DEFAULT 0                     NOT NULL,      -- 階層レベル
    se_max_sort_order    INT            DEFAULT 0                     NOT NULL,      -- 同スレッド内のソート順最大値
    se_root_id           INT            DEFAULT 0                     NOT NULL,      -- ルートスレッドID(ルートの場合は自ID)
    se_parent_id         INT            DEFAULT 0                     NOT NULL,      -- 親スレッドID
    se_sort_order        INT            DEFAULT 0                     NOT NULL,      -- 同スレッド内のソート順
    se_category_id       INT            DEFAULT 0                     NOT NULL,      -- 所属カテゴリー
    se_regist_user_id    INT            DEFAULT 0                     NOT NULL,      -- 投稿者
    se_regist_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 投稿日時
    se_log_serial        INT            DEFAULT 0                     NOT NULL,      -- アクセスログシリアル番号

    se_check_out_user_id INT            DEFAULT 0                     NOT NULL,      -- チェックアウトユーザID(0のときはチェックイン状態)
    se_check_out_dt      TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- チェックアウト日時
    se_create_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード作成者
    se_create_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード作成日時
    se_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    se_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    se_deleted           BOOLEAN        DEFAULT false                 NOT NULL,      -- レコード削除状態
    PRIMARY KEY          (se_serial),
    UNIQUE               (se_id,        se_language_id,               se_history_index)
) TYPE=innodb;

-- BBSグループアクセス権マスター
DROP TABLE IF EXISTS bbs_group_access;
CREATE TABLE bbs_group_access (
    so_group_id          INT            DEFAULT 0                     NOT NULL,      -- グループID(0はゲスト(ログインなし)グループ)
    so_category_id       INT            DEFAULT 0                     NOT NULL,      -- カテゴリーID
    
    so_read              BOOLEAN        DEFAULT false                 NOT NULL,      -- 読み込み権限
    so_write             BOOLEAN        DEFAULT false                 NOT NULL,      -- 書き込み権限

    so_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    so_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    PRIMARY KEY          (so_group_id,  so_category_id)
) TYPE=innodb;

-- BBS会員情報マスター
DROP TABLE IF EXISTS bbs_member;
CREATE TABLE bbs_member (
    sv_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    sv_id                INT            DEFAULT 0                     NOT NULL,      -- 会員ID
    sv_history_index     INT            DEFAULT 0                     NOT NULL,      -- 履歴管理用インデックスNo(0～)
    
    sv_language_id       VARCHAR(2)     DEFAULT ''                    NOT NULL,      -- 対応言語ID
    sv_type              SMALLINT       DEFAULT 0                     NOT NULL,      -- 会員種別(0=仮会員、1=正会員)
    sv_name              VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- 会員名
    sv_login_user_id     INT            DEFAULT 0                     NOT NULL,      -- ログインユーザID
    sv_group             TEXT                                         NOT NULL,      -- 所属グループ
    sv_regist_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 登録日時
    sv_avatar            VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- アバターファイル名
    sv_signature         VARCHAR(200)   DEFAULT ''                    NOT NULL,      -- 署名
    sv_url               TEXT                                         NOT NULL,      -- ホームーページ
    sv_recv_mailnews     BOOLEAN        DEFAULT false                 NOT NULL,      -- 新着情報メールを受信するかどうか

    sv_create_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード作成者
    sv_create_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード作成日時
    sv_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    sv_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    sv_deleted           BOOLEAN        DEFAULT false                 NOT NULL,      -- レコード削除状態
    PRIMARY KEY          (sv_serial),
    UNIQUE               (sv_id,        sv_history_index)
) TYPE=innodb;

-- BBS投稿ログトラン
DROP TABLE IF EXISTS bbs_post_log;
CREATE TABLE bbs_post_log (
    sl_user_id        	 INT            DEFAULT 0                     NOT NULL,      -- 投稿ユーザID
    sl_count             INT            DEFAULT 0                     NOT NULL,      -- 投稿回数
    sl_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 最終投稿日時
    PRIMARY KEY  (sl_user_id)
) TYPE=innodb;

-- BBS投稿参照トラン
DROP TABLE IF EXISTS bbs_view_count;
CREATE TABLE bbs_view_count (
    su_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    su_thread_id         INT            DEFAULT 0                     NOT NULL,      -- スレッドID
    su_language_id       VARCHAR(2)     DEFAULT ''                    NOT NULL,      -- 言語ID
    su_date              DATE           DEFAULT '0000-00-00'          NOT NULL,      -- 日付
    su_hour              SMALLINT       DEFAULT 0                     NOT NULL,      -- 時間
    su_count             INT            DEFAULT 0                     NOT NULL,      -- 参照数
    PRIMARY KEY          (su_serial),
    UNIQUE               (su_thread_id,   su_language_id,         su_date,       su_hour)
) TYPE=innodb;

-- アクセスカウンターウィジェット用
-- アクセス時間管理テーブル
DROP TABLE IF EXISTS ac_access;
CREATE TABLE ac_access (
    ac_ssid              VARCHAR(32)    DEFAULT ''                    NOT NULL,      -- セッションID
    ac_time              INT            DEFAULT 0                     NOT NULL,      -- 最終アクセス時間
    PRIMARY KEY  (ac_ssid)
) TYPE=innodb;

-- アクセス数管理テーブル
DROP TABLE IF EXISTS ac_count;
CREATE TABLE ac_count (
    co_date              DATE           DEFAULT '0000-00-00'          NOT NULL,      -- 日付
    co_count             INT            DEFAULT 0                     NOT NULL,      -- アクセス回数
    PRIMARY KEY  (co_date)
) TYPE=innodb;

-- バナーウィジェット用
-- バナー表示定義
DROP TABLE IF EXISTS bn_def;
CREATE TABLE bn_def (
    bd_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    bd_id                INT            DEFAULT 0                     NOT NULL,      -- バナーID
    bd_item_id           TEXT                                         NOT NULL,      -- 対応バナー項目(「,」区切りで複数指定可)
    bd_name              VARCHAR(50)    DEFAULT ''                    NOT NULL,      -- バナー名
    bd_disp_type         SMALLINT       DEFAULT 0                     NOT NULL,      -- 表示形式(0=サイクリック,1=ランダム)
    bd_first_item_index  INT            DEFAULT 0                     NOT NULL,      -- バナー項目の読み込み位置インデックス(サイクリック時に使用)
    bd_disp_item_count   SMALLINT       DEFAULT 0                     NOT NULL,      -- 同時に表示する項目数
    bd_disp_direction    SMALLINT       DEFAULT 0                     NOT NULL,      -- 表示方向(0=縦,1=横)
    bd_disp_align        SMALLINT       DEFAULT 0                     NOT NULL,      -- 表示位置アラインメント(0=指定なし,1=left,2=center,3=right)
    bd_css_id            VARCHAR(20)    DEFAULT ''                    NOT NULL,      -- CSS用ID
    bd_css               TEXT                                         NOT NULL,      -- CSS
    bd_item_html         TEXT                                         NOT NULL,      -- バナー項目表示テンプレート
    
    bd_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    bd_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    PRIMARY KEY          (bd_serial),
    UNIQUE               (bd_id)
) TYPE=innodb;

-- バナー項目
DROP TABLE IF EXISTS bn_item;
CREATE TABLE bn_item (
    bi_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    bi_id                INT            DEFAULT 0                     NOT NULL,      -- バナー項目ID
    bi_history_index     INT            DEFAULT 0                     NOT NULL,      -- 履歴管理用インデックスNo(0～)
    bi_group             INT            DEFAULT 0                     NOT NULL,      -- グルーピング用
    bi_name              VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- バナー名
    bi_type              INT            DEFAULT 0                     NOT NULL,      -- 項目タイプ(0=画像、1=Flash)
    bi_description       VARCHAR(100)   DEFAULT ''                    NOT NULL,      -- 説明
    bi_admin_note        VARCHAR(100)   DEFAULT ''                    NOT NULL,      -- 管理者用備考
    bi_image_url         TEXT                                         NOT NULL,      -- 表示画像
    bi_link_url          TEXT                                         NOT NULL,      -- リンク先
    bi_image_width       VARCHAR(10)    DEFAULT ''                    NOT NULL,      -- 画像幅
    bi_image_height      VARCHAR(10)    DEFAULT ''                    NOT NULL,      -- 画像高さ
    bi_image_alt         VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- 画像代替テキスト
    bi_image_title       VARCHAR(40)    DEFAULT ''                    NOT NULL,      -- 画像ツールチップ
    bi_html              VARCHAR(200)   DEFAULT ''                    NOT NULL,      -- HTML
    bi_visible           BOOLEAN        DEFAULT true                  NOT NULL,      -- 表示可否
    bi_active_start_dt   TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 表示可能期間(開始)
    bi_active_end_dt     TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 表示可能期間(終了)

    bi_check_out_user_id INT            DEFAULT 0                     NOT NULL,      -- チェックアウトユーザID(0のときはチェックイン状態)
    bi_check_out_dt      TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- チェックアウト日時
    bi_create_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード作成者
    bi_create_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード作成日時
    bi_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    bi_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    bi_deleted           BOOLEAN        DEFAULT false                 NOT NULL,      -- レコード削除状態
    PRIMARY KEY          (bi_serial),
    UNIQUE               (bi_id,        bi_history_index)
) TYPE=innodb;

-- バナー項目参照ログ
DROP TABLE IF EXISTS bn_item_view;
CREATE TABLE bn_item_view (
    bv_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    bv_public_key        CHAR(32)       DEFAULT ''                    NOT NULL,      -- 公開発行キー
    bv_item_serial       INT            DEFAULT 0                     NOT NULL,      -- バナー項目シリアル番号
    bv_log_serial        INT            DEFAULT 0                     NOT NULL,      -- アクセスログシリアル番号
    bv_dt                TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 参照日時
    PRIMARY KEY          (bv_serial)
) TYPE=innodb;

-- バナー項目クリックログ
DROP TABLE IF EXISTS bn_item_access;
CREATE TABLE bn_item_access (
    ba_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    ba_public_key        CHAR(32)       DEFAULT ''                    NOT NULL,      -- 公開発行キー
    ba_redirect_url      TEXT                                         NOT NULL,      -- 遷移先URL
    ba_log_serial        INT            DEFAULT 0                     NOT NULL,      -- アクセスログシリアル番号
    ba_dt                TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 参照日時
    PRIMARY KEY          (ba_serial)
) TYPE=innodb;

-- 予約リソースマスター
DROP TABLE IF EXISTS reserve_resource;
CREATE TABLE reserve_resource (
    rr_id                INT            DEFAULT 0                     NOT NULL,      -- リソースID
    rr_type              INT            DEFAULT 0                     NOT NULL,      -- リソースタイプ(0=常設、1=週間、2=スポット)
    rr_config_id         INT            DEFAULT 0                     NOT NULL,      -- 設定ID
    rr_name              VARCHAR(50)    DEFAULT ''                    NOT NULL,      -- 名称
    rr_description       VARCHAR(80)    DEFAULT ''                    NOT NULL,      -- 説明
    rr_visible           BOOLEAN        DEFAULT true                  NOT NULL,      -- 表示可否
    rr_active_start_dt   TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 有効期間(開始)
    rr_active_end_dt     TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 有効期間(終了)
    rr_sort_order        INT            DEFAULT 0                     NOT NULL,      -- 表示ソート用
    
    rr_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    rr_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    rr_deleted           BOOLEAN        DEFAULT false                 NOT NULL,      -- レコード削除状態
    PRIMARY KEY          (rr_id)
) TYPE=innodb;

-- 予約設定マスター
DROP TABLE IF EXISTS reserve_config;
CREATE TABLE reserve_config (
    rc_id                INT            DEFAULT 0                     NOT NULL,      -- 定義ID
    rc_key               VARCHAR(30)    DEFAULT ''                    NOT NULL,      -- キー
    rc_value             TEXT                                         NOT NULL,      -- 値
    rc_name              VARCHAR(50)    DEFAULT ''                    NOT NULL,      -- 名称
    rc_description       VARCHAR(80)    DEFAULT ''                    NOT NULL,      -- 説明
    rc_index             INT            DEFAULT 0                     NOT NULL,      -- ソート用
    PRIMARY KEY          (rc_id,        rc_key)
) TYPE=innodb;

-- 予約カレンダーマスター
DROP TABLE IF EXISTS reserve_calendar;
CREATE TABLE reserve_calendar (
    ra_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    ra_config_id         INT            DEFAULT 0                     NOT NULL,      -- 設定ID
    ra_usual             BOOLEAN        DEFAULT false                 NOT NULL,      -- 通常あるいは特定日の区別
    ra_specify_type      INT            DEFAULT 0                     NOT NULL,      -- 属性指定方法(0=デフォルト値、1=曜日指定、2=毎月、3=毎年)
    ra_day_attribute     INT            DEFAULT 0                     NOT NULL,      -- 日にち属性(0=未設定、1～7=日曜～土曜、8=祝日)
    ra_date              DATE           DEFAULT '0000-00-00'          NOT NULL,      -- 日にち指定の場合の日にち
    ra_start_time        INT            DEFAULT 0                     NOT NULL,      -- 日にち時間範囲指定の場合の開始時間(hhmm)
    ra_end_time          INT            DEFAULT 0                     NOT NULL,      -- 日にち時間範囲指定の場合の終了時間(hhmm)
    ra_available         BOOLEAN        DEFAULT false                 NOT NULL,      -- 利用可能かどうか
    PRIMARY KEY          (ra_serial)
) TYPE=innodb;

-- 予約状況トラン
DROP TABLE IF EXISTS reserve_status;
CREATE TABLE reserve_status (
    rs_serial            INT            AUTO_INCREMENT,                              -- レコードシリアル番号
    rs_resource_id       INT            DEFAULT 0                     NOT NULL,      -- リソースID
    rs_user_id           INT            DEFAULT 0                     NOT NULL,      -- ユーザID
    rs_status            INT            DEFAULT 0                     NOT NULL,      -- 状態(1=予約、2=キャンセル)
    rs_start_dt          TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- 開始日時
    rs_note              VARCHAR(100)   DEFAULT ''                    NOT NULL,      -- 備考
    
    rs_create_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード作成者
    rs_create_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード作成日時
    rs_update_user_id    INT            DEFAULT 0                     NOT NULL,      -- レコード更新者
    rs_update_dt         TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,      -- レコード更新日時
    rs_deleted           BOOLEAN        DEFAULT false                 NOT NULL,      -- レコード削除状態
    PRIMARY KEY          (rs_serial)
) TYPE=innodb;
