<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_mainPageinfoWidgetContainer.php 2407 2009-10-12 05:30:18Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() . '/admin_mainMasterBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');

class admin_mainPageinfoWidgetContainer extends admin_mainMasterBaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;	// システム情報取得用
	private $pageId;	// ページID
	private $pageSubId;	// ページサブID
	private $defaultSubId;	// デフォルトのページサブID
	private $contentType;
	private $useSsl;		// SSLを使用するかどうか
	private $serialArray = array();		// 表示されている項目シリアル番号
	private $contentTypeArray;		// コンテンタイプ
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new admin_mainDb();
		$this->sysDb = $this->gInstance->getSytemDbObject();
		
		// コンテンツタイプ
		$this->contentTypeArray = array(	array(	'name' => '指定なし',					'value' => ''),
											array(	'name' => '標準コンテンツ(content)',	'value' => 'content'),
											array(	'name' => '製品(product)',				'value' => 'product'),
											array(	'name' => 'Wiki(wiki)',					'value' => 'wiki'));
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'pageinfo_detail'){		// 詳細画面
			return 'pageinfo_detail.tmpl.html';
		} else {			// 一覧画面
			return 'pageinfo.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'pageinfo_detail'){	// 詳細画面
			return $this->createDetail($request);
		} else {			// 一覧画面
			return $this->createList($request);
		}
	}
	/**
	 * 一覧画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createList($request)
	{
		// パラメータの取得
		$task = $request->trimValueOf('task');		// 処理区分
		$act = $request->trimValueOf('act');
		$this->pageId = $request->trimValueOf('pageid');		// ページID
		$this->pageSubId = $request->trimValueOf('pagesubid');// ページサブID
		
		// ページメインIDメニュー作成
		// 選択中のページIDを決定
		$this->db->getPageIdList(array($this, 'pageIdLoop'), 0/*ページID*/);
		
		// デフォルトのページサブIDを取得
		$this->defaultSubId = $this->sysDb->getDefaultPageSubId($this->pageId);
		
		// ページサブID一覧を作成
		$this->db->getPageSubIdList($this->pageId, array($this, 'pageSubIdLoop'));
		
		$this->tmpl->addVar("_widget", "serial_list", implode($this->serialArray, ','));// 表示項目のシリアル番号を設定
	}
	/**
	 * 詳細画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createDetail($request)
	{
		$act = $request->trimValueOf('act');
		$this->pageId = $request->trimValueOf('pageid');		// ページID
		$this->pageSubId = $request->trimValueOf('pagesubid');// ページサブID
		$this->contentType = $request->trimValueOf('item_contenttype');// コンテンツタイプ
		$this->useSsl = ($request->trimValueOf('item_use_ssl') == 'on') ? 1 : 0;		// SSLを使用するかどうか
		$default = ($request->trimValueOf('item_default') == 'on') ? 1 : 0;		// デフォルトページかどうか
		
		$replaceNew = false;		// データを再取得するかどうか
		if ($act == 'update'){		// 更新のとき
			// 入力チェック
			$this->checkInput($this->pageId, 'ページID');
			$this->checkInput($this->pageSubId, 'ページサブID');
			
			// エラーなしの場合は、データを更新
			if ($this->getMsgCount() == 0){
				// デフォルトページの変更
				$ret = true;
				if ($default) $ret = $this->sysDb->updateDefaultPageSubId($this->pageId, $this->pageSubId);
				
				// ページ情報の更新
				if ($ret) $ret = $this->db->updatePageInfo($this->pageId, $this->pageSubId, $this->contentType,
														''/*テンプレートID*/, 0/*アクセス制御ユーザタイプ*/, $this->useSsl);

				if ($ret){		// データ追加成功のとき
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
					$replaceNew = true;			// データを再取得
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}
			}
		} else {		// 初期状態
			$replaceNew = true;			// データを再取得
		}
		// 表示データ再取得
		$name = '';
		if ($replaceNew){
			$ret = $this->db->getPageInfo($this->pageId, $this->pageSubId, $row);
			if ($ret){
				$this->contentType = $row['pn_content_type'];
				$this->useSsl = $row['pn_use_ssl'];// SSLを使用するかどうか
				$name = $row['pg_name'];
			}
		}

		// コンテンツタイプメニュー作成
		$this->createContentTypeMenu();
		
		// デフォルトのページサブIDを取得
		$this->defaultSubId = $this->sysDb->getDefaultPageSubId($this->pageId);
		$default = '';
		if ($this->pageSubId == $this->defaultSubId) $default = 'checked';
		
		$checked = '';
		if (!empty($this->useSsl)) $checked = 'checked';
		$this->tmpl->addVar("_widget", "use_ssl_checked", $checked);		// SSLを使用するかどうか
		$this->tmpl->setAttribute('update_button', 'visibility', 'visible');// 更新ボタン表示
		$this->tmpl->addVar("_widget", "page_id", $this->pageId);			// ページID
		$this->tmpl->addVar("_widget", "page_subid", $this->pageSubId);		// ページサブID
		$this->tmpl->addVar("_widget", "name", $name);		// ページ名
		$this->tmpl->addVar("_widget", "default", $default);		// デフォルトのページかどうか
	}
	/**
	 * ページID、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function pageIdLoop($index, $fetchedRow, $param)
	{
		// デフォルトのページIDを取得
		if (empty($this->pageId)) $this->pageId = $fetchedRow['pg_id'];
		
		$selected = '';
		if ($fetchedRow['pg_id'] == $this->pageId){
			$selected = 'selected';
			
			// デフォルトのページサブIDを取得
			$this->defaultPageSubId = $fetchedRow['pg_default_sub_id'];		// デフォルトのページID
		}
		$name = $this->convertToDispString($fetchedRow['pg_id']) . ' - ' . $this->convertToDispString($fetchedRow['pg_name']);			// ページ名
		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['pg_id']),			// ページID
			'name'     => $name,			// ページ名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('main_id_list', $row);
		$this->tmpl->parseTemplate('main_id_list', 'a');
		return true;
	}
	/**
	 * ページサブID、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function pageSubIdLoop($index, $fetchedRow, $param)
	{
		$pid = $fetchedRow['pg_id'];
		$value = $this->convertToDispString($pid);
		
		// デフォルトページ
		$default = '';
		if ($pid == $this->defaultSubId) $default = 'checked';
		
		// 公開状況
		$public = '';
		if ($fetchedRow['pg_active']) $public = 'checked';
		
		// SSLを使用するかどうか
		$ssl = '';
		if ($fetchedRow['pn_use_ssl']) $ssl = 'checked';
		
		$row = array(
			'index'    => $index,			// インデックス番号
			'value'    => $value,			// ページID
			'name'     => $this->convertToDispString($fetchedRow['pg_name']),			// ページ名
			'content_type'     => $this->convertToDispString($fetchedRow['pn_content_type']),			// コンテンツタイプ
			'public'	=> $public,			// ページ公開
			'ssl'		=> $ssl,			// SSLを使用するかどうか
			'default'	=> $default		// デフォルトのページサブID
		);
		$this->tmpl->addVars('sub_id_list', $row);
		$this->tmpl->parseTemplate('sub_id_list', 'a');
		
		// 表示中項目のページサブIDを保存
		$this->serialArray[] = $value;
		return true;
	}
	/**
	 * コンテンツタイプ選択メニュー作成
	 *
	 * @return なし
	 */
	function createContentTypeMenu()
	{
		for ($i = 0; $i < count($this->contentTypeArray); $i++){
			$value = $this->contentTypeArray[$i]['value'];
			$name = $this->contentTypeArray[$i]['name'];
			$selected = '';
			if ($value == $this->contentType) $selected = 'selected';
			$row = array(
				'value'    => $value,			// ページID
				'name'     => $name,			// ページ名
				'selected' => $selected														// 選択中かどうか
			);
			$this->tmpl->addVars('content_type_list', $row);
			$this->tmpl->parseTemplate('content_type_list', 'a');
		}
	}
}
?>
