<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: m_pc_contentWidgetContainer.php 876 2008-08-04 08:37:17Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/pc_contentDb.php');
require_once($gEnvManager->getCommonPath() . '/valueCheck.php');

class m_pc_contentWidgetContainer extends BaseWidgetContainer
{
	var $db;			// DB接続オブジェクト
	var $_contentCreated;	// コンテンツが取得できたかどうか
	var $currentDay;		// 現在日
	var $currentHour;		// 現在時間
	const CONTENT_TYPE = 'ct';		// 参照数カウント用
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new pc_contentDb();
	}
	/**
	 * ウィジェット単位のアクセス制御
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 */
	function _checkAccess($request)
	{
		return true;
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'main.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		
		// 現在日時を取得
		$this->currentDay = date("Y/m/d");		// 日
		$this->currentHour = (int)date("H");		// 時間

		$contentid = $request->trimValueOf('contentid');
		if (empty($contentid)){	// コンテンツIDがないときはデフォルトデータを取得
			$this->db->getContentItems(array($this, 'itemsLoop'), null, $gEnvManager->getCurrentLanguage());
			if (!$this->_contentCreated){		// コンテンツが取得できなかったときはデフォルト言語で取得
				$this->db->getContentItems(array($this, 'itemsLoop'), null, $gEnvManager->getDefaultLanguage());
			}
		} else {
			// データエラーチェック
			$contentIdArray = explode(',', $contentid);
			if (ValueCheck::isNumeric($contentIdArray)){		// すべて数値であるかチェック
				$this->db->getContentItems(array($this, 'itemsLoop'), $contentIdArray, $gEnvManager->getCurrentLanguage());
				if (!$this->_contentCreated){		// コンテンツが取得できなかったときはデフォルト言語で取得
					$this->db->getContentItems(array($this, 'itemsLoop'), $contentIdArray, $gEnvManager->getDefaultLanguage());
				}
			} else {
				$this->setAppErrorMsg('IDにエラー値があります');
			}
		}
	}
	/**
	 * 取得したコンテンツ項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function itemsLoop($index, $fetchedRow)
	{
		global $gEnvManager;
		global $gAnalyzeManager;
		global $gTextConvManager;
			
		// ビューカウントを更新
		if (!$gEnvManager->isSystemAdmin()){		// システム管理者の場合はカウントしない
			$gAnalyzeManager->updateContentViewCount(self::CONTENT_TYPE, $fetchedRow['cn_serial'], $this->currentDay, $this->currentHour);
		}

		// タイトルを設定
		$title = $fetchedRow['cn_name'];
		
		// HTMLを出力
		// 出力内容は特にエラーチェックしない
		//$contentText = $this->convertToDispString($fetchedRow['cn_html']);
		$contentText = $fetchedRow['cn_html'];
		$contentText = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $contentText);// アプリケーションルートを変換
		
		// 登録したキーワードを変換
		$gTextConvManager->convByKeyValue($contentText, $contentText, true/*改行コーをbrタグに変換*/);
		
		$row = array(
			'title' => $title,
			'content' => $contentText	// コンテンツ
		);
		$this->tmpl->addVars('contentlist', $row);
		$this->tmpl->parseTemplate('contentlist', 'a');
		
		// コンテンツが取得できた
		$this->_contentCreated = true;
		return true;
	}
}
?>
