<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_bbs_mainThreadWidgetContainer.php 2 2007-11-03 04:59:01Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/bbs_mainThreadDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/bbs_mainDb.php');

class admin_bbs_mainThreadWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $mainDb;	// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	private $serialNo;		// 選択中の項目のシリアル番号
	private $entryId;
	private $lang;		// 現在の選択言語
	private $threadArray = array();		// 表示中のスレッド
	private $search_categoryId;		// 検索カテゴリー
	private $defaultLangId;			// デフォルト言語
	const THIS_WIDGET_ID = 'bbs_main';			// ウィジェットID
	const DEFAULT_LIST_COUNT = 100;			// 最大リスト表示数
	const DEFAULT_THREAD_STATUS = 2;				// 表示
	const CAN_EDIT_THREAD	= 'can_edit_thread';		// 投稿記事の編集を可能にするかどうか
			
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new bbs_mainThreadDb();
		$this->mainDb = new bbs_mainDb();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'admin_thread.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		return $this->createContentList($request, $param);
	}
	/**
	 * コンテンツ一覧画面作成
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function createContentList($request, &$param)
	{
		global $gEnvManager;
		
		$now = date("Y/m/d H:i:s");	// 現在日時

		// ユーザ情報、表示言語
		$userId = $gEnvManager->getCurrentUserId();
		$this->defaultLangId = $gEnvManager->getDefaultLanguage();
		$defaultLangName = $gEnvManager->getDefaultLanguageNameByCurrentLanguage();// デフォルト言語の現在の表示名を取得
		$canEditThread = $this->mainDb->getConfig(self::CAN_EDIT_THREAD);		// 記事の編集を可能にするかどうか
		
		$act = $request->trimValueOf('act');
		$this->entryId = $request->trimValueOf('threadid');		// 記事ID
		$this->serialNo = $request->trimValueOf('serial');		// 選択項目のシリアル番号
		$this->langId = $request->trimValueOf('item_lang');				// 現在メニューで選択中の言語
		if (empty($this->langId)) $this->langId = $this->defaultLangId;			// 言語が選択されていないときは、デフォルト言語を設定	
		
		$name = $request->trimValueOf('item_name');
		//$html = $request->valueOf('item_html');
		$html = $request->trimValueOf('item_html');	// HTML形式は使用しない
		$status = $request->trimValueOf('item_status');		// エントリー状態(0=未設定、1=保留、2=表示、3=非表示)
		if (empty($status)) $status = self::DEFAULT_THREAD_STATUS;
//		$category = $request->trimValueOf('search_category');					// カテゴリー
		$closed = ($request->trimValueOf('item_closed') == 'on') ? 1 : 0;		// 終了状態
		
		// ##### 検索条件 #####
		$pageNo = $request->trimValueOf('page');				// ページ番号
		if (empty($pageNo)) $pageNo = 1;
		// DBの保存設定値を取得
		$maxListCount = self::DEFAULT_LIST_COUNT;				// 表示項目数
		$serializedParam = $this->sysDb->getWidgetParam(self::THIS_WIDGET_ID);
		if (!empty($serializedParam)){
			$dispInfo = unserialize($serializedParam);
			$maxListCount = $dispInfo->listCountByAdmin;		// 一覧表示数
		}
		$search_startDt = $request->trimValueOf('search_start');		// 検索範囲開始日付
		if (!empty($search_startDt)) $search_startDt = $this->convertToProperDate($search_startDt);
		$search_endDt = $request->trimValueOf('search_end');			// 検索範囲終了日付
		if (!empty($search_endDt)) $search_endDt = $this->convertToProperDate($search_endDt);
		$this->search_categoryId = $request->trimValueOf('search_category');		// 検索カテゴリー
		$search_keyword = $request->trimValueOf('search_keyword');			// 検索キーワード
		
		$dataReload = false;		// データの再ロード
		$dataInit = false;			// データ初期化

		if ($act == 'search'){		// 検索のとき
			//if (empty($this->search_categoryId)) $this->setUserErrorMsg('カテゴリを選択してください');
			if (!empty($search_startDt) && !empty($search_endDt) && $search_startDt > $search_endDt){
				$this->setUserErrorMsg('期間の指定範囲にエラーがあります');
			}
			$pageNo = 1;		// ページ番号初期化
			$dataInit = true;			// データ初期化
		} else if ($act == 'selpage'){			// ページ選択
			$dataInit = true;			// データ初期化
		} else if ($act == 'select'){		// 一覧から選択のとき
			if ($act == 'select') $this->langId = $this->defaultLangId;		// 言語は一旦リセット
			
			// 登録済みのコンテンツデータを取得
			$this->serialNo = $this->db->getEntrySerialNoById($this->entryId, $this->langId);
			if (empty($this->serialNo)){
				// 取得できないときは初期化
				$dataInit = true;		// データ初期化
			} else {
				$dataReload = true;		// データの再ロード
			}
		} else if ($act == 'add'){		// 項目追加の場合
			// 入力チェック
			$this->checkInput($name, 'タイトル');
			if (empty($this->search_categoryId)) $this->setUserErrorMsg('カテゴリを選択してください');
					
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				//if ($act == 'add'){
					//$ret = $this->db->addEntryItem(0, $this->langId, $name, $html, $status, $closed, $this->search_categoryId, $userId, $now, $userId, $newSerial);
					$logSerial = $gEnvManager->getCurrentAccessLogSerial();	// 現在のログ
					$ret = $this->db->addNewThread(0, $this->langId, 0/*ルートスレッド*/, $name, $html, $this->search_categoryId, $logSerial, $userId, $now, $userId, $newSerial);
				//} else {
				//	$ret = $this->db->addEntryItem($this->entryId, $this->langId, $name, $html, $status, $closed, $this->search_categoryId, $userId, $now, $userId, $newSerial);
				//}
				if ($ret){
					$this->setGuidanceMsg('データを追加しました');
					
					// 投稿ログを残す
					$this->mainDb->updatePostLog($userId);
										
					// シリアル番号更新
					$this->serialNo = $newSerial;
					$dataReload = true;		// データの再ロード
				} else {
					$this->setAppErrorMsg('データ追加に失敗しました');
				}
			}
		} else if ($act == 'update'){		// 項目更新の場合
			// 入力チェック
			$this->checkInput($name, 'タイトル');
			if (empty($this->search_categoryId)) $this->setUserErrorMsg('カテゴリを選択してください');
			
			// エラーなしの場合は、データを更新
			if ($this->getMsgCount() == 0){
				$ret = $this->db->updateThreadItem($this->serialNo, $name, $html, $status, $closed, $this->search_categoryId, ''/*投稿者そのまま*/, ''/*投稿日時そのまま*/, $userId, $newSerial);
				if ($ret){
					$this->setGuidanceMsg('データを更新しました');
					// シリアル番号更新
					$this->serialNo = $newSerial;
					$dataReload = true;		// データの再ロード
				} else {
					$this->setAppErrorMsg('データ更新に失敗しました');
				}
			}				
		} else if ($act == 'deleteid'){		// ID項目削除の場合
			if (empty($this->serialNo)){
				$this->setUserErrorMsg('削除項目が選択されていません');
			}
			// エラーなしの場合は、データを削除
			if ($this->getMsgCount() == 0){
				$ret = $this->db->delEntryItemById($this->serialNo, $userId);
				if ($ret){		// データ削除成功のとき
					$this->setGuidanceMsg('データを削除しました');
				} else {
					$this->setAppErrorMsg('データ削除に失敗しました');
				}
			}
		} else {	// 初期画面表示のとき
			$dataInit = true;		// データ初期化
		}
		// 設定データを再取得
		if ($dataReload){		// データの再ロード
			$ret = $this->db->getEntryBySerial($this->serialNo, $row);
			if ($ret){
				$this->entryId = $row['se_id'];		// エントリーID
				$name = $row['se_name'];				// タイトル
				$html = $row['se_html'];				// HTML
				$html = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $html);// アプリケーションルートを変換
				$status = $row['se_status'];				// エントリー状況
				$closed = $row['se_closed'];				// 終了状況
				$reg_user = $row['reg_user_name'];				// 投稿者
				$reg_dt = $this->convertToDispDateTime($row['se_regist_dt']);				// 投稿日時
				$update_user = $this->convertToDispString($row['lu_name']);// 更新者
				$update_dt = $this->convertToDispDateTime($row['se_create_dt']);
			}
		}
		// データ初期化
		if ($dataInit){
			$this->serialNo = 0;
			$this->entryId = 0;
			
			$name = '';				// タイトル
			$html = '';				// HTML
			$status = self::DEFAULT_THREAD_STATUS;				// エントリー状況
			$closed = 0;
			$reg_user = '';				// 投稿者
			$reg_dt = '';				// 投稿日時
			$update_user = '';// 更新者
			$update_dt = '';							
		}
		// 非表示項目を設定
		$this->tmpl->addVar("_widget", "serial", $this->serialNo);	// シリアル番号
		$this->tmpl->addVar("_widget", "entry_id", $this->entryId);	// エントリーID
		$this->tmpl->addVar("_widget", "page", $pageNo);	// ページ番号
		
		// 入力フィールドの設定、共通項目のデータ設定
		if ($this->entryId == 0){		// コンテンツIDが0のときは、新規追加モードにする
			$this->tmpl->setAttribute('add_button', 'visibility', 'visible');
		} else {
			if ($this->serialNo == 0){		// 未登録データのとき
				// データ追加ボタン表示
				$this->tmpl->setAttribute('add_button', 'visibility', 'visible');
			} else {
				// データ更新、削除ボタン表示
				if ($this->langId == $this->defaultLangId){		// デフォルト言語のとき
					$this->tmpl->setAttribute('delete_id_button', 'visibility', 'visible');// デフォルト言語のときは全削除
				} else {
					$this->tmpl->setAttribute('delete_button', 'visibility', 'visible');// デフォルト言語以外はデータ削除
				}
				$this->tmpl->setAttribute('update_button', 'visibility', 'visible');
				
				// 編集不可の場合は、ボタンを使用不可にする
				if (!$canEditThread){
					$this->tmpl->addVar("delete_id_button", "disabled", "disabled");
					$this->tmpl->addVar("delete_button", "disabled", "disabled");
				}
			}
		}
		// ###### 一覧の取得条件を作成 ######
		// カテゴリー一覧を作成
		$this->db->getAllCategory($this->defaultLangId, array($this, 'categoryLoop'));
						
		if (!empty($search_endDt)) $endDt = $this->getNextDay($search_endDt);
		
		// 総数を取得
		$totalCount = $this->db->getEntryItemCount($search_startDt, $endDt, $this->search_categoryId, $search_keyword, $this->defaultLangId);

		// 表示するページ番号の修正
		$pageCount = (int)(($totalCount -1) / $maxListCount) + 1;		// 総ページ数
		if ($pageNo < 1) $pageNo = 1;
		if ($pageNo > $pageCount) $pageNo = $pageCount;
		$this->firstNo = ($pageNo -1) * $maxListCount + 1;		// 先頭番号
		
		// ページング用リンク作成
		$pageLink = '';
		if ($pageCount > 1){	// ページが2ページ以上のときリンクを作成
			for ($i = 1; $i <= $pageCount; $i++){
				if ($i == $pageNo){
					$link = '&nbsp;' . $i;
				} else {
					$link = '&nbsp;<a href="#" onclick="selpage(\'' . $i . '\');return false;">' . $i . '</a>';
				}
				$pageLink .= $link;
			}
		}
		$this->tmpl->addVar("_widget", "page_link", $pageLink);
		$this->tmpl->addVar("_widget", "total_count", $totalCount);
		
		// 記事項目リストを取得
		$this->db->searchEntryItems($maxListCount, $pageNo, $search_startDt, $endDt, $this->search_categoryId, $search_keyword, $this->defaultLangId, array($this, 'itemListLoop'));
		
		// 選択中のコンテンツIDを設定
		$this->tmpl->addVar("_widget", "thread_id", $this->entryId);
		if ($this->entryId == 0){		// エントリーIDが0のときは新規とする
			$this->tmpl->addVar("_widget", "id", '新規');			// エントリーID
			$this->tmpl->addVar("_widget", "new_selected", 'checked');// コンテンツIDが0のときは新規追加をチェック状態にする
		} else {
			$this->tmpl->addVar("_widget", "id", $this->entryId);			// エントリーID
		}
		$this->tmpl->addVar("_widget", "thread_array", implode($this->threadArray, ','));
		
		// ### 入力値を再設定 ###
		$this->tmpl->addVar("_widget", "item_name", $name);		// 名前
		$this->tmpl->addVar("_widget", "item_html", $html);		// HTML
		switch ($status){
			case 1:	$this->tmpl->addVar("_widget", "selected_edit", 'selected');	break;
			case 2:	$this->tmpl->addVar("_widget", "selected_public", 'selected');	break;
			case 3:	$this->tmpl->addVar("_widget", "selected_closed", 'selected');	break;
		}
		$checked = '';
		if ($closed){	// 終了状況
			$checked = 'checked';
		}
		$this->tmpl->addVar("_widget", "closed", $checked);	// 終了状況
		$this->tmpl->addVar("_widget", "entry_user", $reg_user);	// 投稿者
		$this->tmpl->addVar("_widget", "entry_dt", $reg_dt);	// 投稿日時
		$this->tmpl->addVar("_widget", "update_user", $update_user);	// 更新者
		$this->tmpl->addVar("_widget", "update_dt", $update_dt);	// 更新日時
		// 編集状況を設定
		if ($this->serialNo != 0 && !$canEditThread){		// 登録データで編集不可の場合
			$this->tmpl->addVar("_widget", "name_readonly", 'readonly');	// タイトル
			$this->tmpl->addVar("_widget", "thread_readonly", 'readonly');	// 本文
		}
		
		// 検索条件
		$this->tmpl->addVar("_widget", "search_start", $search_startDt);	// 開始日付
		$this->tmpl->addVar("_widget", "search_end", $search_endDt);	// 終了日付
		
		// パスの設定
		$this->tmpl->addVar("_widget", "root_url", $gEnvManager->getRootUrl());
		$this->tmpl->addVar("_widget", "widget_sc_url", $gEnvManager->getCurrentWidgetScriptsUrl());
		$this->tmpl->addVar("_widget", "script_url", $gEnvManager->getScriptsUrl());
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function itemListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;
		
		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		// 項目選択のラジオボタンの状態
		$id = $this->convertToDispString($fetchedRow['se_id']);
		$selected = '';
		if ($id == $this->entryId){
			$selected = 'checked';
		}
		
		// 公開状態
		switch ($fetchedRow['se_status']){
			case 1:	$status = '<font color="orange">保留</font>';	break;
			case 2:	$status = '<font color="green">表示</font>';	break;
			case 3:	$status = '<font color="gray">非表示</font>';	break;
		}
		
		// カテゴリー名を取得
		$category = '';
		if (!empty($fetchedRow['se_category_id'])){
			if ($this->db->getCategoryByCategoryId($fetchedRow['se_category_id'], $this->langId, $row)) $category = $row['sr_name'];
		/*
			if ($this->db->getCategoryRecords($fetchedRow['se_category'], $this->defaultLangId, $rows)){
				for ($i = 0; $i < count($rows); $i++){
					$category .= $rows[$i]['sr_name'];
					if ($i != count($rows) -1) $category .= ',';
				}
			}*/
		}

		$row = array(
			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'serial' => $fetchedRow['se_serial'],			// シリアル番号
			'id' => $id,			// ID
			'name' => $this->convertToDispString($fetchedRow['se_name']),		// 名前
			'lang' => $lang,													// 対応言語
			'category' => $category,												// 所属カテゴリー
			'status' => $status,													// 公開状況
			'reg_user' => $this->convertToDispString($fetchedRow['lu_name']),	// 投稿者
			'reg_date' => $this->convertToDispDateTime($fetchedRow['se_regist_dt']),	// 投稿日時
			'update_user' => $this->convertToDispString($fetchedRow['lu_name']),	// 更新者
			'update_date' => $this->convertToDispDateTime($fetchedRow['se_create_dt']),	// 更新日時
			'selected' => $selected												// 項目選択用ラジオボタン
		);
		$this->tmpl->addVars('itemlist', $row);
		$this->tmpl->parseTemplate('itemlist', 'a');
		
		$this->threadArray[] = $id;		// 表示中のスレッド
		return true;
	}
	/**
	 * 取得したカテゴリーをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function categoryLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$selected = '';
		if ($fetchedRow['sr_id'] == $this->search_categoryId){
			$selected = 'selected';
		}
		$name = $this->convertToDispString($fetchedRow['sr_name']);

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['sr_id']),			// カテゴリーID
			'name'     => $name,			// カテゴリー名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('category_list', $row);
		$this->tmpl->parseTemplate('category_list', 'a');
		return true;
	}
}
?>
