<?php
/**
 * Ajax操作マネージャー
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: ajaxManager.php 2 2007-11-03 04:59:01Z fishbone $
 * @link       http://www.magic3.org
 */
require_once(M3_SYSTEM_LIB_PATH . '/JSON.php');

class AjaxManager
{
	private $_sendJsonToClient = true;			// JSONデータをクライアントに送信するかどうか
    /**
     * M3-JSONヘッダーへ出力する値を配列でもちます
     * $jsonData['retcode']		// レスポンス戻り値
     * $jsonData['data']		// JSON実データ
     */
    var $jsonData;
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// データ初期化
		$this->jsonData				= array();
		$this->jsonData['retcode']	= 0;
		$this->jsonData['data']		= array();
	}
	/**
	 * JSON型データで出力する値を追加
	 *
	 * $key,$valueのセットで呼び出すか、または、連想配列を$keyにセットして呼び出す。
	 *
	 * @param string key			キー項目
	 * @param string value			値項目
	 */
	function addData($key, $value='')
	{
		if (is_array($key)){
			foreach($key as $k => $v){
				$this->jsonData['data'][$k] = $v;
			}
		} else {
			$this->jsonData['data'][$key] = $value;
		}
	}
	/**
	 * JSON型データで出力する値をすべて消去
	 */
	function clearData()
	{
		$this->jsonData['data'] = array();
	}
	/**
	 * Ajax通信のクライアント戻り値を設定
	 *
	 * @param int $value			クライアント戻り値
	 */
	function setReturnCode($value)
	{
		$this->jsonData['retcode'] = $value;
	}
	/**
	 * JSONデータをヘッダに追加するかどうかの制御
	 *
	 * @param bool $status			true=JSONデータ送信、false=JSONデータ送信しない
	 */
	function setSendJsonToClient($status)
	{
		$this->_sendJsonToClient = $status;
	}	 
	/**
	 * JSONデータをHTTPヘッダに出力
	 *
	 * メンバ変数のJSONデータをHTTPヘッダに出力する
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 */
	function header($request)
	{
		// 送信不可であれば何もしないで終了
		if (!$this->_sendJsonToClient) return;
		
		$json = new Services_JSON();
		$retData = $json->encode($this->jsonData);
		if (!empty($retData)) header('X-JSON: ' . '(' . $retData . ')');
	}
	
}
?>
