<?php
/**
 * すべてのリクエストを受け持ちます.
 * @package magic.web
 * @author T.Okumura
 * @version 1.0.0
 */
/**
 * コンテキストルート
 * @var string
 */
if (!defined('ROOT')) {
    define('ROOT', dirname(dirname(__FILE__)) . DIRECTORY_SEPARATOR);
}
/**
 * アプリケーションのディレクトリ.
 * @var string
 */
if (!defined('APP')) {
    define('APP', ROOT . 'app' . DIRECTORY_SEPARATOR);
}
/**
 * ドキュメントルートになるディレクトリ.
 * @var string
 */
if (!defined('WEB')) {
    define('WEB', ROOT . 'web' . DIRECTORY_SEPARATOR);
}
/**
 * フレームワークのディレクトリ.
 * @var string
 */
if (!defined('CORE')) {
    define('CORE', ROOT . 'core' . DIRECTORY_SEPARATOR);
}
/**
 * コントローラーを読み込みます.
 * <p>
 * アプリケーション側でコントローラーを作成した場合は、
 * ここの呼び出しを変更してください。
 * 例えば、<br/>
 * require_once APP . 'AppController.php';<br/>
 * $controller = new AppController();<br/>
 * $controller->dispatch();<br/>
 * となります。
 * </p>
 */
require_once CORE . 'Controller.php';
$controller = new Controller();
$controller->dispatch();
// EOF.