<?php
/**
 * Mailer.
 * @package magic.core
 * @subpackage tool.mail
 */
/**
 * メール送信クラスのインターフェイスです.
 * <p>
 * このクラスは必要な時に実装クラスによってロードされます。
 * </p>
 * @package magic.core
 * @subpackage tool.mail
 * @author T.Okumura
 * @version 1.0.0
 */
interface Mailer {
    /**
     * FROMを設定します.
     * @param string $from
     */
    function setFrom($from);
    /**
     * TOを設定します.
     * @param string $to
     */
    function setTo($to);
    /**
     * 送信処理.
     * <p>
     * このファンクションが返す結果は、送信までの結果です。<br/>
     * これは先方に届いたかどうかではない事に注意してください。
     * </p>
     * @param string $header メールヘッダ
     * @param string $body メールボディ
     * @return bool 正常に送信されればTRUE
     */
    function send($header, $body);
    /**
     * 直近のエラーを取得します.
     * @return string 発生した直近のエラー
     */
    function getError();
}
// EOF.