<?php
/**
 * SystemMessage.
 * @package magic.core
 * @subpackage helper.message
 */
/**
 * フレームワークが使用するメッセージです.
 * <p>
 * これらのメッセージは、{@link MagicException}によって使用されます。<br/>
 * アプリケーション側のメッセージクラスは、必ずこのクラスまたは
 * {@link SystemMessage_en}を継承して作成するようにしてください。
 * </p>
 * @package magic.core
 * @subpackage helper.message
 * @author T.Okumura
 * @version 1.0.0
 */
class SystemMessage {
    /**
     * コンストラクタ.
     */
    public function __construct() {
    }
    // メッセージのキーです。
    /**
     * クラスパスが不正.
     * @staticvar string
     */
    const SYS001 = 'クラスパスが不正です。[%s]';
    /**
     * クラスが継承されていない.
     * @staticvar string
     */
    const SYS002 = '%sクラスを継承してください。[%s]';
    /**
     * インターフェイスが実装されていない.
     * @staticvar string
     */
    const SYS003 = '%sインターフェイスを実装してください。[%s]';
    /**
     * クラスがロードできない.
     * @staticvar string
     */
    const SYS004 = 'クラスのロードに失敗しました。[%s]';
    /**
     * ファンクションの取得に失敗.
     * @staticvar string
     */
    const SYS005 = 'ファンクションが見つかりませんでした。[%s]';
    /**
     * 戻り値が不正.
     * @staticvar string
     */
    const SYS006 = '必ず%sをreturnしてください。[%s]';
    /**
     * HTMLファイルのパスが不正.
     * @staticvar string
     */
    const SYS007 = 'HTMLファイルが見つかりませんでした。[%s]';
    /**
     * メッセージの引数が不正.
     * @staticvar string
     */
    const SYS008 = 'メッセージの引数が不正です["%s" : %s]。%sクラスのコード[%s]。';
    /**
     * メッセージが見つからない.
     * @staticvar string
     */
    const SYS009 = 'メッセージコード[%s]は、%sクラスで見つかりませんでした。';
    // 置換文字列も、このように設定できます。
    /**
     * 引数がない場合.
     * @staticvar string
     */
    const NOTHING = '引数がありません';
}
// EOF.