<?php
/**
 * HttpFile.
 * @package magic.core
 * @subpackage helper.http
 */
/**
 * マルチパートリクエストのファイルを管理するクラスです.
 * <p>
 * <var>$_FILES</var>を操作するための機能を提供します。
 * </p>
 * @package magic.core
 * @subpackage helper.http
 * @author T.Okumura
 * @version 1.0.0
 * @final
 */
final class HttpFile {
    /**
     * ファイルのname属性を保持します.
     * @var string
     */
    private $_inputName = NULL;
    /**
     * コンストラクタ.
     */
    public function __construct() {
    }
    /**
     * ファイルのnameを設定します.
     * <p>
     * HTMLファイルの<br/>
     * ＜input type="file" name="xxx"<br/>
     * タグのname属性と一致させる必要があります。
     * </p>
     * <p>
     * 予めこのファンクションで名前が設定されている場合は、
     * 各ファンクションのオプション引数を省略できます。<br/>
     * ここで指定していなければ、個別に指定する必要があります。
     * </p>
     * @param string $inputName ファイルのname属性
     */
    public function setInputName($inputName) {
        $this->_inputName = $inputName;
    }
    /**
     * ファイルを取得します.
     * @param string $key 取得する値のキー
     * @param string $inputName [optional] 取得するファイルのname属性(オプション)
     * @return mixed 取得できた場合はそのファイル、できなければFALSE
     */
    public function get($key, $inputName = NULL) {
        $inputName = is_null($inputName) ? $this->_inputName : $inputName;
        if (array_key_exists($inputName, $_FILES)) {
            $files = $_FILES[$inputName];
            return array_key_exists($key, $files) ? $files[$key] : FALSE;
        }
        return FALSE;
    }
    /**
     * すべてのファイルを取得します.
     * <p>
     * 返されるのはファイルのコピーです。<br/>
     * これによって返された配列に変更を加えても、元の<var>$_FILES</var>の内容は変更されない事に注意してください。
     * </p>
     * @return array コピーされたファイルの配列
     */
    public function getFile() {
        $copy = $_FILES;
        return $copy;
    }
    /**
     * ファイルの名前を取得します.
     * @param string $inputName [optional] 取得するファイルのname属性(オプション)
     * @param int $index [optional] ファイルが複数の場合、0から始まるインデックス番号(オプション)
     * @return mixed 存在しなければFALSE、インデックスが指定されていればその名前、省略されていれば最初の名前
     */
    public function getName($inputName = NULL, $index = 0) {
        return ($names = $this->getNameArray($inputName)) ? $names[$index] : FALSE;
    }
    /**
     * すべてのファイルのファイル名の配列を取得します.
     * <p>
     * このファンクションは、常にarrayを返します。<br/>
     * リクエストされたファイルが一つだと分かっている場合には、{@link getName()}を使用する方が便利です。
     * </p>
     * @param string $inputName [optional] 取得するファイルのname属性(オプション)
     * @return mixed 存在しなければFALSE、存在していればファイル名の配列
     * @see getName()
     */
    public function getNameArray($inputName = NULL) {
        if ($names = $this->get('name', $inputName)) {
            return is_array($names) ? $names : array($names);
        }
        return FALSE;
    }
    /**
     * ファイルのファイルタイプを取得します.
     * @param string $inputName [optional] 取得するファイルのname属性(オプション)
     * @param int $index [optional] ファイルが複数の場合、0から始まるインデックス番号(オプション)
     * @return mixed 存在しなければFALSE、インデックスが指定されていればそのファイルのタイプ、省略されていれば最初のファイルのタイプ
     */
    public function getType($inputName = NULL, $index = 0) {
        return ($types = $this->getTypeArray($inputName)) ? $types[$index] : FALSE;
    }
    /**
     * すべてのファイルのファイルタイプの配列を取得します.
     * <p>
     * このファンクションは、常にarrayを返します。<br/>
     * リクエストされたファイルが一つだと分かっている場合には、{@link getType()}を使用する方が便利です。
     * </p>
     * @param string $inputName [optional] 取得するファイルのname属性(オプション)
     * @return mixed 存在しなければFALSE、存在していればファイルタイプの配列
     * @see getType()
     */
    public function getTypeArray($inputName = NULL) {
        if ($types = $this->get('type', $inputName)) {
            return is_array($types) ? $types : array($types);
        }
        return FALSE;
    }
    /**
     * ファイルのファイルサイズを取得します.
     * @param string $inputName [optional] 取得するファイルのname属性(オプション)
     * @param int $index [optional] ファイルが複数の場合、0から始まるインデックス番号(オプション)
     * @return mixed 存在しなければFALSE、インデックスが指定されていればそのファイルのサイズ、省略されていれば最初のファイルのサイズ
     */
    public function getSize($inputName = NULL, $index = 0) {
        return ($sizes = $this->getSizeArray($inputName)) ? $sizes[$index] : FALSE;
    }
    /**
     * すべてのファイルのファイルサイズの配列を取得します.
     * <p>
     * このファンクションは、常にarrayを返します。<br/>
     * リクエストされたファイルが一つだと分かっている場合には、{@link getSize()}を使用する方が便利です。
     * </p>
     * @param string $inputName [optional] 取得するファイルのname属性(オプション)
     * @return mixed 存在しなければFALSE、存在していればファイルサイズの配列
     * @see getSize()
     */
    public function getSizeArray($inputName = NULL) {
        if ($sizes = $this->get('size', $inputName)) {
            return is_array($sizes) ? $sizes : array($sizes);
        }
        return FALSE;
    }
    /**
     * ファイルの一時保存先を取得します.
     * @param string $inputName [optional] 取得するファイルのname属性(オプション)
     * @param int $index [optional] ファイルが複数の場合、0から始まるインデックス番号(オプション)
     * @return mixed 存在しなければFALSE、インデックスが指定されていればそのファイルの一時保存先、省略されていれば最初のファイルの一時保存先
     */
    public function getTmpName($inputName = NULL, $index = 0) {
        return ($tmpNames = $this->getTmpNameArray($inputName)) ? $tmpNames[$index] : FALSE;
    }
    /**
     * すべてのファイルの一時保存先の配列を取得します.
     * <p>
     * このファンクションは、常にarrayを返します。<br/>
     * リクエストされたファイルが一つだと分かっている場合には、{@link getTmpName()}を使用する方が便利です。
     * </p>
     * @param string $inputName [optional] 取得するファイルのname属性(オプション)
     * @return mixed 存在しなければFALSE、存在していれば一時保存先の配列
     * @see getTmpName()
     */
    public function getTmpNameArray($inputName = NULL) {
        if ($tmpNames = $this->get('tmp_name', $inputName)) {
            return is_array($tmpNames) ? $tmpNames : array($tmpNames);
        }
        return FALSE;
    }
}
// EOF.