<?php
/**
 * SessionRedirect.
 * @package magic.core
 * @subpackage helper.action.impl
 */
/**
 * リダイレクト処理を実行します.
 * <p>
 * 別のURLにリダイレクトします。<br/>
 * {@link Redirect}クラスとの違いは、セッションIDを
 * 自動的にクエリパラメータに書き出すかどうかだけです。<br/>
 * Cookieが利用できない場合などに、{@link Redirect}クラスで処理を実行すると、
 * セッションが継続できなくなる事に注意してください。<br/>
 * 特に携帯端末を対象にしたアプリケーションが対象になります。<br/>
 * アプリケーション側でtransSidを付与するか、このクラスを使用するようにしてください。<br/>
 * Cookieが利用できる場合やセッションを使用しない場合は、このクラスを利用してください。
 * </p>
 * @package magic.core
 * @subpackage helper.action.impl
 * @author T.Okumura
 * @version 1.0.0
 * @final
 * @see Redirect
 */
final class SessionRedirect extends ActionResult {
    /**
     * リダイレクト先のパスを保持します.
     * @var string
     */
    private $_path = NULL;
    /**
     * GET引数に追加するクエリパラメータを保持します.
     * @var array
     */
    private $_parameters = array();
    /**
     * コンストラクタ.
     * @param string $path リダイレクト先のパス
     * @param array $parameters [optional] GET引数に追加するクエリパラメータ(オプション)
     */
    public function __construct($path, array $parameters = array()) {
        $this->_path = $path;
        $this->_parameters = $parameters;
    }
    /**
     * Viewクラスの{@link View::redirect()}を実行します.
     * <p>
     * セッションIDを書き出さないように指定してコールします。
     * </p>
     * @param NameConfigure $name 命名規則設定クラス
     * @param PathConfigure $path パス設定クラス
     * @param RouteConfigure $route ルート設定クラス
     * @see ActionResult::execute()
     */
    public function execute(NameConfigure $name, PathConfigure $path, RouteConfigure $route) {
        $view = new View();
        $view->redirect($this->_path, $this->_session, TRUE, $this->_parameters);
    }
}
// EOF.