<?php
/**
 * Forward.
 * @package magic.core
 * @subpackage helper.action.impl
 */
/**
 * フォワード処理を実行します.
 * <p>
 * ViewクラスからHTMLファイルにレンダリングします。<br/>
 * {@link SessionForward}クラスとの違いは、セッションIDを
 * 自動的にhidden項目に書き出すかどうかだけです。<br/>
 * Cookieが利用できない場合にこのクラスで処理を実行すると、
 * セッションが継続できなくなる事に注意してください。<br/>
 * 特に携帯端末を対象にしたアプリケーションが対象になります。<br/>
 * アプリケーション側で(セキュリティの観点からは、あまりお勧めできませんが)
 * transSidを付与するか、{@link SessionForward}クラスを使用するようにしてください。<br/>
 * Cookieが利用できる場合やセッションを使用しない場合は、このクラスを利用してください。
 * </p>
 * @package magic.core
 * @subpackage helper.action.impl
 * @author T.Okumura
 * @version 1.0.0
 * @final
 * @see SessionForward
 */
final class Forward extends ActionResult {
    /**
     * コールするViewクラス名を保持します.
     * @var string
     */
    private $_viewName = NULL;
    /**
     * コンストラクタ.
     * <p>
     * Actionクラスの名前とコールするViewクラスの名前が同じ場合、
     * この引数は省略できます。<br/>
     * </p>
     * @param string $viewName [optional] コールするViewクラス名(オプション)
     */
    public function __construct($viewName = NULL) {
        $this->_viewName = $viewName;
    }
    /**
     * Viewクラスの{@link View::forward()}を実行します.
     * <p>
     * セッションIDを書き出さないように指定してコールします。
     * </p>
     * @param NameConfigure $name 命名規則設定クラス
     * @param PathConfigure $path パス設定クラス
     * @param RouteConfigure $route ルート設定クラス
     * @see ActionResult::execute()
     */
    public function execute(NameConfigure $name, PathConfigure $path, RouteConfigure $route) {
        ViewClassLoader::load($this->_viewName, $name, $path, $route)
                ->forward($this->_response, $this->_session, $name, $path, FALSE);
    }
}
// EOF.