<?php
/**
 * ActionResult.
 * @package magic.core
 * @subpackage helper.action
 */
/**
 * Actionクラスの実行結果クラスです.
 * <p>
 * アプリケーションのActionクラスは、必ずこのクラスを
 * 継承したクラスを返す必要があります。
 * </p>
 * @package magic.core
 * @subpackage helper.action
 * @author T.Okumura
 * @version 1.0.0
 * @abstract
 */
abstract class ActionResult {
    /**
     * HttpResponseクラスを保持します.
     * @var HttpResponse
     */
    protected $_response = NULL;
    /**
     * HttpSessionクラスを保持します.
     * @var HttpSession
     */
    protected $_session = NULL;
    /**
     * HttpResponseクラスを設定します.
     * @param HttpResponse $response HttpResponseクラス
     */
    final public function setResponse(HttpResponse $response) {
        $this->_response = $response;
    }
    /**
     * HttpResponseクラスを取得します.
     * @return HttpResponse
     */
    final public function getResponse() {
        return $this->_response;
    }
    /**
     * HttpSessionクラスを設定します.
     * @param HttpSession $response HttpSessionクラス
     */
    final public function setSession(HttpSession $session) {
        $this->_session = $session;
    }
    /**
     * HttpSessionクラスを取得します.
     * @return HttpSession
     */
    final public function getSession() {
        return $this->_session;
    }
    /**
     * Viewクラスを実行します.
     * <p>
     * Viewクラスを実行しない場合もあります。
     * </p>
     * @param NameConfigure $name 命名規則設定クラス
     * @param PathConfigure $path パス設定クラス
     * @param RouteConfigure $route ルート設定クラス
     */
    abstract public function execute(NameConfigure $name, PathConfigure $path, RouteConfigure $route);
}
// EOF.