<?php
/**
 * RouteConfigureImpl.
 * @package magic.core
 * @subpackage config.impl
 */
/**
 * リクエストURLから呼び出すクラスを解決する、デフォルトの実装クラスです.
 * <p>
 * このクラスは必要な時に{@link Controller}によってロードされます。
 * </p>
 * @package magic.core
 * @subpackage config.impl
 * @author T.Okumura
 * @version 1.0.0
 * @final
 */
final class RouteConfigureImpl implements RouteConfigure {
    /**
     * {@link HttpRequest}クラスを保持します.
     * @var HttpRequest
     */
    private $_request = NULL;
    /**
     * コンストラクタ.
     * @param HttpRequest $request HttpRequestクラス
     * @see HttpRequest
     */
    public function __construct(HttpRequest $request) {
        $this->_request = $request;
    }
    /**
     * Actionクラス名を取得する、デフォルトの設定です.
     * <p>
     * リクエストのクエリパラメータから、'action'をキーとした値を返します。<br/>
     * 見つからない場合は、'Index'という文字列を返します。
     * </p>
     * @see RouteConfigure::getActionName()
     */
    public function getActionName() {
        return ($action = $this->_request->get('action')) ? $action : 'Index';
    }
    /**
     * ファンクション名を取得する、デフォルトの設定です.
     * <p>
     * リクエストのクエリパラメータから、'target'をキーとした値を返します。<br/>
     * 見つからない場合は、'index'という文字列を返します。
     * </p>
     * @see RouteConfigure::getMethodName()
     */
    public function getMethodName() {
        return ($method = $this->_request->get('target')) ? $method : 'index';
    }
}
// EOF.